
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include <Intrins.h>
#include "REG_MA82G5Dxx.H"
#include "delay.H"


union WTYPE
  { uCHAR B[2];
    uINT  W;
  };

float ADC_Volt;
float VDD_Volt;

union WTYPE ADC_Value;
union WTYPE ADC_Ch0_Value;
union WTYPE ADC_Ch1_Value;
union WTYPE ADC_Ch2_Value;

void WriteP(uCHAR PsfrAddr,uCHAR PsfrData)
{
		bit bEA=EA;
		EA = 0; 					// ж
		IFADRH = 0; 				// IFADRHΪ0
		IFADRL= PsfrAddr;			// Pҳַ;
		IFD= PsfrData;				// Pҳ
		IFMT = 4;					// дPҳ
		ISPCR = 0x80;				// ISP/IAP
		SCMD = 0x46;
		SCMD = 0xB9;
		_nop_();
		ISPCR = 0;					// ISP/IAPĴ
		IFMT=0;
		EA = bEA;					// ָж
}
void Initial_ADC(void)
{
	ADCON0 = (ADCEN | CHS3 | CHS2 | CHS1 | CHS0);		// ADC Channel select Int 1.4V
	ADCFG0 = (ADRJ | ADCKS1 | ADCKS0);					// SYSCLK / 8 ADRJ=1: ADCH(------B9B8),ADCL(B7B6B5B4B3B2B1B0)
	WriteP(PCON3_P,0x80);								// Enable IVR 1.4V
	delay_ms(10);
}

void ADC_Start(void)
{
	ADCON0 |= 0x08;										//start AD conversion
	while(!(ADCON0 & 0x10));							//wait AD conversion finish
	ADCON0 &= 0xEF;										//Clear ADC interrupt flag

	ADC_Value.B[0] = ADCDH;								//get ADC value
	ADC_Value.B[1] = ADCDL;
}

void main(void)
{

	Initial_ADC();


	ADC_Start();
	ADC_Ch0_Value.W = ADC_Value.W;

	VDD_Volt = 1.4*1023 / ADC_Ch0_Value.W;				// ʹͨ Int 1.4VADCֵVDDĵѹֵ
	ADC_Volt = VDD_Volt / 1023 * ADC_Value.W;

	while(1)
	{
		_nop_();
	}
}
