/*********************************************************************
    Ŀ:MA82G5D16-DEMO
			԰ʹ MA82G5Dxx	SSOP28 EV Board (TH178A)
			CpuCLK=12MHz, SysCLK=12MHz
	
			RTCʱΪXTAL 32.768KHz
			RTC Clock ԤƵ 32768
			RTC ֵ (64-1)=63
			RTCƵΪ 32768/32768/1 = 1Hz
			ģʽ, RTC,KBI,exINT0
	ע

    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5D16.H"
#include ".\include\API_Uart_BRGRL_MA82G5D16.H"


/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.25MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26

u8 WakeFlag;
enum{
	WAKE_BY_RTC=0,
	WAKE_BY_ExINT0,
	WAKE_BY_KBI,
	WAKE_BY_OTHER
};

u8	CurrentSecond;		//
u8	CurrentMinute;		//
u8	CurrentHour;		//ʱ
u8	CurrentDay;			//
u8	CurrentMonth;		//
u8	CurrentYear;		//
u8 	DayMax;

code u8 MonthDayTable[]={1,31+1,29+1,31+1,30+1,31+1,30+1,31+1,31+1,30+1,31+1,30+1,31+1};

/*************************************************
: char putchar (char c)   
: printf Ĵ
:     char c
:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}


/***********************************************************************************
:   void INT_SF(void)
:SF(ϵͳ־λ)жϷ
		 RTC,WDTF,BOD0F,BOD1F
:   
ز:     
*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1&WDTF)!=0)
	{
		PCON1=WDTF;
	}
	if((PCON1&BOF0)!=0)
	{
		PCON1=BOF0;
	}
	if((PCON1&BOF1)!=0)
	{
		PCON1=BOF1;
	}
	if((PCON1&RTCF)!=0)
	{
		PCON1=RTCF;							// жϱ־
		WakeFlag=WAKE_BY_RTC;
		PCON1 = PCON1 | RTCF;		
		CurrentSecond++;
		if(CurrentSecond>=60)
		{
			CurrentSecond = 0;
			CurrentMinute++;
			if(CurrentMinute>=60)
			{
				CurrentMinute = 0;
				CurrentHour++;
				if(CurrentHour>=24)
				{
					CurrentHour =0;
					CurrentDay++;
					if(CurrentMonth==2)
					{
						if((CurrentYear%4)==0)
						{
							DayMax=29+1;
						}
						else
						{
							DayMax=28+1;
						}
					}
					else
					{
						DayMax=MonthDayTable[CurrentMonth];
					}
					if(CurrentDay>=DayMax)
					{
						CurrentDay=1;
						CurrentMonth++;
						if(CurrentMonth>=13)
						{
							CurrentMonth=1;
							CurrentYear++;
							if(CurrentYear>=100)
							{
								CurrentYear=0;
							}
						}
					}
				}
			}
		}
	}
}


/***********************************************************************************
:   void INT_KBI(void)	
:KBIжϷ
:   
ز:     
*************************************************************************************/
void INT_KBI(void)		interrupt INT_VECTOR_KB
{
	INT_DisKBI();				// ֹKBIж
	KBCON&=(~KBIF);				// жϱ־
	WakeFlag=WAKE_BY_KBI;
}

/***********************************************************************************
:   void INT_EXINT(void)	
:INT0жϷ
:   
ز:     
*************************************************************************************/
void INT_INT0(void)		interrupt INT_VECTOR_INT0
{
	INT_DisINT0();				// ֹExINT0ж
	WakeFlag=WAKE_BY_ExINT0;	
}


/***********************************************************************************
:   u8 IAP_ReadPPage(u8 PsfrAddr)
:ȡPҳ⹦
:   
		 u8 PsfrAddr: Pҳַ
ز:     
		 u8: Pҳ
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
	return IFD;
}

/***********************************************************************************
:void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
:дPҳ⹦
:   
		 u8 PsfrAddr: Pҳַ,u8 PsfrData:  Pҳ
ز:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}


/*************************************************
:     void DelayXus(u16 xUs)
:   	ʱ򣬵λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
:     void DelayXms(u16 xMs)
:     ʱ򣬵λΪms
:     u16 xMs -> *1ms  (1~65535)
:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
:   void InitUart0_T1(void)
:   Uart0ʼ,ʹT1ΪԴ
:   
ز:     
*************************************************************************************/
void InitUart0_T1(void)
{
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART0
	UART0_SetBRGFromT1();				// òԴΪ T1
	UART0_SetT1BaudRateX2();			// 2x

	TM_SetT1Mode_2_8BIT_AUTORELOAD();
	TM_SetT1Clock_SYSCLK();
	TM_SetT1Gate_Disable();

    // ò
	TM_SetT1HighByte(T1_BRGRL_9600_2X_12000000_1T);
	TM_SetT1LowByte(T1_BRGRL_9600_2X_12000000_1T);

	TM_EnableT1();
	
}


/***********************************************************************************
:   void InitRTC(void)
:RTC ʼ	
		RTCʱΪILRCO 32KHz
		RTC Clock ԤƵ 32
		RTC ֵ (64-1)=63
		RTCƵΪ 32K/32768/1~=1Hz
:   
ز:     
*************************************************************************************/
void InitRTC(void)
{	
	u8 x;
	x=IAP_ReadPPage(CKCON2_P);
	x=(x&0x3F)|(ENABLE_XTAL|GAIN_FOR_32K);
	IAP_WritePPage(CKCON2_P,x);
	while(CKCON1 & XTOR == 0x00);		// ȴXTAL׼
	
	RTC_SetClock_ECKI_P60();		// ѡRTCʱΪ XTAL 32.768KHz
	RTC_SetClock_Div_32768();			// ѡRTC Clock ԤƵ 32768
	RTC_SetReload(64-1);				// RTC ֵ (64-1)=63
	RTC_SetCounter(64-1);	
	RTC_ClearRTCF();					// RTCF
	RTC_Enable();						// ʹRTC
	
}

/***********************************************************************************
:   void InitKBI(void)
:   KBIʼ
:   
ز:     
*************************************************************************************/
void InitKBI(void)
{
	KBI_SetKBMask(KBI0|KBI1);				//ʹKBI0KBI1ͨ
	KBI_SetKBI01P10P11();					//ʹKBI0KBI1P10P11KBI
	KBI_SetKBPattern(KBI0_1|KBI1_1);		//KBIȽֵΪKBI0KBI1ĸߵƽ
	KBI_SetPatternNotEqual();				//IOƽֵȽֵʱƥ
	KBI_SetFilter_Sysclk_x3();				//KBI˲
}

/***********************************************************************************
:   void InitINT0(void)
:   INT0ʼ
:   
ز:     
*************************************************************************************/
void InitINT0(void)
{
	INT_SetINT0P30();						//INT0P30
	INT_SetINT0_DetectEdge();				//INT0ⲿжϼⷽʽΪؼ, ģʽ,ԶתΪƽ
	INT_SetINT0_DetectLowFalling();			//INT0ⲿжϼⷽʽΪ͵ƽ½ش
	INT_SetINT0Filter_SysclkDiv6_x3();		//INT0˲Ϊsysclk/6*3

}



/***********************************************************************************
:   void InitInterrupt(void)
:InitInterruptʼ
:   
ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_RTC();			// ʹRTCж,ʹϵͳ־ж
	INT_EnSF();				// ʹϵͳ־ж
}


/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);					//  P22,P24,P26 Ϊ LED
	PORT_SetP1OpenDrainPu(BIT0|BIT1|BIT5|BIT6);			//  P10,P11,P15,P16Ϊ©
}



/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	
	InitRTC();	
	InitKBI();
	InitINT0();
	InitUart0_T1();

	InitInterrupt();		// жϳʼ
	
	INT_EnAll();			// ʹȫж

}

/***********************************************************************************
:   void PowerDown()
:  ģʽ͹
ú:        
:   
ز:     
*************************************************************************************/
void PowerDown(void)
{
	//u8 BakCKCON2;			// CKCON2 (ʹPLL CKMƵ)
	u8 i;
	// ȴѽ P10/P11/P30 Ϊߵƽ
	P10=1;P11=1;P30=1;
	i=0;
	do{
		DelayXus(100);
		if((P10==1)&&(P11==1)&&(P30==1))
		{
			i++;
		}
		else
		{
			i=0;
		}
	}while(i<200);

	// MCK=OSCin
	//BakCKCON2=IAP_ReadPPage(CKCON2_P);							// CKCON2 (ʹPLL CKMƵ)
	//IAP_WritePPage(CKCON2_P,BakCKCON2&(~(MCKS0_P|MCKS1_P)));		// MCK=OSCin (ʹPLL CKMƵ)

	INT_ClrINT0();		// ExINT0жϱ־
	INT_ClrKBI();		// KBIжϱ־
	INT_EnINT0();		// ʹExINT0ж
	INT_EnKBI();		// ʹKBIж
SLEEP_AGAIN:
	WakeFlag=WAKE_BY_OTHER;
	POW_SetMode_PD();			//ģʽ

	_nop_();					// ѺȽжϷ
	_nop_();					// 

	if(WakeFlag==WAKE_BY_RTC)
	{
		goto SLEEP_AGAIN;
	}
	
	//DelayXus(100);												// ʱCKMȶ (ʹPLL CKMƵ)
	//IAP_WritePPage(CKCON2_P,BakCKCON2);							// ָCKCON2,ѡʹñƵ (ʹPLL CKMƵ)
}


void main()
{
	u8 i;
	
	
    InitSystem();

	CurrentYear=21;
	CurrentMonth=3;
	CurrentDay=9;
	CurrentHour=10;
	CurrentMinute=23;
	CurrentSecond=0;
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
		printf("\nTime:20%bd-%bd-%bd %bd:%bd:%bd",CurrentYear,CurrentMonth,CurrentDay,CurrentHour,CurrentMinute,CurrentSecond);
    	for(i=0;i<20;i++)
    	{
	    	DelayXms(100);
	    	LED_G_0=!LED_G_0;
    	}
    	// ˯
		printf("\nPower down!!");
		PowerDown();
		printf("\nWake up!! 0x%02bX",WakeFlag);
    	
    }
}

