
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include <intrins.h>                             // for _nop_();
#include "REG_MA82G5Dxx.H"
#include "delay.H"


#define		EPCA		0x04
#define		ECOMn		0x40
#define		CAPPn		0x20
#define		CAPNn		0x10
#define		MATn		0x08
#define		PWMn		0x02
#define		ECCFn		0x01

#define		CCF0		0x01

#define		EPCA		0x04

#define    ISP_ENABLE          0x80              // Set ISP Enable
#define    ISP_DISABLE         0x00              // Set ISP Disable

#define		MCU_12MHz			0x01
#define		MCU_24MHz			0x02

#define		MCU_Freq			MCU_24MHz

union WTYPE
  { uCHAR B[2];
    uINT W;
  };

union WTYPE PCA_Cnt;
uINT PCA_Interval;

uCHAR PCA_Interrupt_Flag;


void PageP_Write(uCHAR Addr, uCHAR Dta)
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Dta;
	IFMT = 0x04;								//write
	ISPCR = ISP_ENABLE;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR Addr)
{
	uCHAR Dta;

	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;								//read
	ISPCR = ISP_ENABLE;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;

	Dta = IFD;
	return Dta;
}

void INT_PCA(void)	interrupt	9	using	1
{
	CL = 0x00;
	CH = 0x00;
	CCON &= ~CCF0;
	
	PCA_Cnt.B[0] = CCAP0H;
	PCA_Cnt.B[1] = CCAP0L;
	
	PCA_Interrupt_Flag = 1;
	

}

void Initial_PCA(void)
{

	SFRPI=0;							  		// CEX0(P22) : Open-Drain With Pull High
	P2M0=P2M0|P2M02;
	SFRPI=1;
	P2M1=P2M1|P2M12;
	SFRPI=0;

	CCAPM0 = (CAPNn | ECCFn);					//falling edge capture
	CMOD = 0x0A;								//CPS2 ~ CPS0 = 1, 0, 1. (SYSCLK)
	CCON = 0x40;								//PCA run.

	EIE1 = EPCA;
}

void Initial_MCU_Sysclk(void)
{
	uCHAR tmp;

	#if(MCU_Freq == MCU_24MHz)
	
		CKCON0 |= ENCKM;
		delay_ms(1);
		tmp = PageP_Read(CKCON2_P);
		tmp |= MCKS0;
		PageP_Write(CKCON2_P, tmp);
	
	#endif

}

void main()
{
	Initial_PCA();
	Initial_MCU_Sysclk();
	EA = 1;

	while(1){
		if(PCA_Interrupt_Flag)
		{
			PCA_Interrupt_Flag = 0;
			#if(MCU_Freq == MCU_12MHz)
			
				PCA_Interval = PCA_Cnt.W / 12;				// PCA_Cnt.W / 12M * 1000000 = us.
			#elif(MCU_Freq == MCU_24MHz)
			
				PCA_Interval = PCA_Cnt.W / 24;				// PCA_Cnt.W / 12M * 1000000 = us.
			#endif
		}
		
	}
}



