
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include <Intrins.h>		// for _nop_()

#include "REG_MA82G5Dxx.H"
#include "delay.H"


#define		AFS					0x80
#define		CKCON2				0x40

#define	T0X12			0x04

#define	CR0			0x01
#define	CR1			0x02
#define	AA			0x04
#define	SI			0x08
#define	STO			0x10
#define	STA			0x20
#define	ENSI		0x40
#define	CR2			0x80

#define _TWSI_TIME_MAX_		2000

uCHAR tmp;
uCHAR TWI0_Err;

uCHAR I2C_Read(uCHAR Dev_Addr, uCHAR Reg_Addr)
{	
	uCHAR	usData = 0;
	uINT 	cnt = 0;

	SICON |= STA;
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0R_End;
		}
	}
	SICON &= ~STA;

	SIDAT = Dev_Addr;							// send device address
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0R_End;
		}
	}

	SIDAT = Reg_Addr;							// send register address
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0R_End;
		}
	}


	SICON |= STA;								// restart
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0R_End;
		}
	}
	SICON &= ~STA;

	SIDAT = Dev_Addr | 0x01;					// send device address
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0R_End;
		}
	}

	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0R_End;
		}
	}
	usData = SIDAT;

	SICON |= STO;
	SICON &= ~SI;
	cnt = 0;
	while((SICON&STO) == STO)
	{	
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0R_End;
		}
	}
TWI0R_End:
	return usData;
}

void I2C_Write(uCHAR Dev_Addr, uCHAR Reg_Addr, uCHAR ucData)
{
	uINT 	cnt = 0;
	SICON |= STA;
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0W_End;
		}
	}
	SICON &= ~STA;

	SIDAT = Dev_Addr;							// send device address
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0W_End;
		}
	}

	SIDAT = Reg_Addr;							// send register address
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0W_End;
		}
	}

	SIDAT = ucData;								// send data
	SICON &= ~SI;
	cnt = 0;
	while( (SICON&SI) != SI)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0W_End;
		}
	}

    SICON |= STO;
    SICON &= ~SI;
	cnt = 0;
	while( (SICON&STO) == STO)
	{
		cnt++;
		if(cnt > _TWSI_TIME_MAX_)
		{	
			TWI0_Err = 1;
			goto TWI0W_End;
		}
	}
TWI0W_End:
	_nop_();
}

void Timer0_Initial(void)
{
	TMOD = 0x02;
	TH0 = 0xEC;
	TL0 = 0xEC;
	TR0 = 1;
	AUXR2 = T0X12;

}

void TWI0_Init()
{
	SICON=0x00;
	//P22,P24 is Open drain with pull high
	P2M0=P2M0|(P2M02|P2M04);
	SFRPI=1;
	P2M0=P2M1|(P2M12|P2M14);
	SFRPI=0;
	_nop_();
	_nop_();
	_nop_();
	AUXR3 = 0x06;      			//sel P22/P24 as SCL/SDA	 
	SICON = ( CR2 | ENSI | CR1 | CR0 );		//enable TWSI and clock source Timer0 overflow, I2C Freq is 100KHz.
}

void main(void)
{
	Timer0_Initial();
	TWI0_Init();
	

	while(1)
	{
		TWI0_Err=0;
		I2C_Write(0xA0, 0xAA, 0xA5);
		if(TWI0_Err)
		{// TWI Err. Reset TWI 
			TWI0_Init();
		}
		delay_ms(5);
	
		TWI0_Err=0;
		tmp = I2C_Read(0xA0, 0xAA);
		if(TWI0_Err)
		{// TWI Err. Reset TWI 
			TWI0_Init();
		}
		delay_ms(5);
			
	}
}
