/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"
#include "bsp_usart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
 * @brief  Main program.
 * @param  None
 * @return None
 */
int main(void)
{
  NVIC_InitTypeDef NVIC_Struct;

  /* Enbale TRNG clock */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_RNG, ENABLE);
  
  /* Initialize usart1 */
  usart1_init(SystemCoreClock, 115200);
  
  /* Enable the TRNG interrupt */
  TRNG_ITCmd(ENABLE);
  /* Enable TRNG */
  TRNG_Cmd(ENABLE);  
  
  /* Configure the TRNG interrupt request */
  NVIC_Struct.NVIC_IRQChannel = RNG_IRQn;
  NVIC_Struct.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Struct.NVIC_IRQChannelPreemptionPriority = 1;
  NVIC_Struct.NVIC_IRQChannelSubPriority = 1;
  NVIC_Init(&NVIC_Struct); 
  
  /* Infinite loop */
  while (1)
  {
  }
}

/**
 * @brief  This function handles TRNG interrupt request.
 * @param  None
 * @note   Data ready bit in SR register can not be cleared.
 * @return None
 */
void RNG_IRQHandler(void)
{
  uint32_t i;

  if(TRNG_GetITStatus(TRNG_IT_DRDY) != RESET)
  {
    /* Get true random generated data and print data on serial port 1 */
    i= TRNG_GetData();
    printf("TRNG Interrupt Now !\t");
    printf("%u\r\n", i);
  }
}

#ifdef  USE_FULL_ASSERT
/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param  file: pointer to the source file name
 * @param  line: assert_param error line source number
 * @return None
 */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
