/* Includes ------------------------------------------------------------------*/
#include "mg32F157.h"
#include "string.h"
#include "stdio.h"
#include "bsp_usart1.h"
#include "bsp_sdio_sdcard.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t SDIO_ReadBuf[4096] = {0};
uint8_t SDIO_WriteBuf[4096] = {0};

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
uint32_t RNG_Get(void)
{
  while (TRNG_GetFlagStatus(TRNG_FLAG_DRDY) == RESET);

  return TRNG_GetData();
}

void delay(uint32_t n)
{
  while(n--);
}

int main(void)
{
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_RNG, ENABLE);
  usart1_init(96000000, 115200);
  printf("SDIO Write Read SD CARD \r\n");

  TRNG_Cmd(ENABLE);
  SD_Init();

  for(uint32_t i = 0; i < sizeof(SDIO_WriteBuf); i ++)
  {
    SDIO_WriteBuf[i] = RNG_Get();
  }

  printf("SDIO Write Read SD CARD \r\n");
  printf(">>>>>>>>>>>  Test item 1  <<<<<<<<<< \r\n");
  printf("  Single block read and write tests \r\n");
  SD_WriteBlock(SDIO_WriteBuf, 0x0, 512);
  while (SD_GetStatus() != SD_TRANSFER_OK);

  SD_ReadBlock(SDIO_ReadBuf, 0, 512);

  if(!memcmp(SDIO_WriteBuf, SDIO_ReadBuf, 512))
  {
    printf("  Test Success \r\n");
  }
  else
  {
    printf("  Test Error \r\n");
  }

  printf(">>>>>>>>>>>  Test item 2  <<<<<<<<<< \r\n");
  printf("  Single block write read test\r\n");
  SD_WriteBlock(SDIO_WriteBuf + 64, 1024, 512);
  while (SD_GetStatus() != SD_TRANSFER_OK);

  SD_ReadBlock(SDIO_ReadBuf, 1024, 512);

  if(!memcmp(SDIO_WriteBuf + 64, SDIO_ReadBuf, 512))
  {
    printf("  Test Success \r\n");
  }
  else
  {
    printf("  Test Error \r\n");
  }

  printf(">>>>>>>>>>>  Test item 3  <<<<<<<<<< \r\n");
  printf("  Single block write Multer block read test\r\n");
  SD_WriteBlock(SDIO_WriteBuf + 1096, 512, 512);
  while (SD_GetStatus() != SD_TRANSFER_OK);
  SD_WriteBlock(SDIO_WriteBuf + 584, 0, 512);
  while (SD_GetStatus() != SD_TRANSFER_OK);

  SD_ReadMultiBlocks(SDIO_ReadBuf, 0, 512, 2);
  
  if(!memcmp(SDIO_WriteBuf + 584, SDIO_ReadBuf, 1024))
  {
    printf("  Test Success \r\n");
  }
  else
  {
    printf("  Test Error \r\n");
  }
  
  printf(">>>>>>>>>>>  Test item 4  <<<<<<<<<< \r\n");
  printf("  Single block write Multer block read test\r\n");
  SD_WriteBlock(SDIO_WriteBuf + 88, 0, 512);
  while (SD_GetStatus() != SD_TRANSFER_OK);
  SD_WriteBlock(SDIO_WriteBuf + 600, 512, 512);
  while (SD_GetStatus() != SD_TRANSFER_OK);
  SD_WriteBlock(SDIO_WriteBuf + 1112, 1024, 512);
  while (SD_GetStatus() != SD_TRANSFER_OK);

  SD_ReadMultiBlocks(SDIO_ReadBuf, 0x0, 512, 3);

  if(!memcmp(SDIO_WriteBuf + 88, SDIO_ReadBuf, 1536))
  {
    printf("  Test Success \r\n");
  }
  else
  {
    printf("  Test Error \r\n");
  }

  printf(">>>>>>>>>>>  Test item 5  <<<<<<<<<< \r\n");
  printf("  Multer block write Multer block read test\r\n");
  SD_WriteMultiBlocks(SDIO_WriteBuf, 0, 512, 8);

  SD_ReadMultiBlocks(SDIO_ReadBuf, 0x0, 512, 8);

  if(!memcmp(SDIO_WriteBuf, SDIO_ReadBuf, 4096))
  {
    printf("  Test Success \r\n");
  }
  else
  {
    printf("  Test Error \r\n");
  }

  /* Infinite loop */
  while (1)
  {
  }
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
