#include "bsp_usart1.h"


/**
  * @name    uart1_init
  * @brief   Init UART1
  * @param   apbclk: UART1 APB Clock frequency
  * @param   baud: Baudrate to configure
  * @retval  None
  */
void usart1_init(uint32_t apbclk, uint32_t baud)
{
  /* Enable UART1 and GPIOA Clock */
  RCC->APB2ENR |= (RCC_APB2ENR_USART1EN | RCC_APB2ENR_IOPAEN);
  
  /* Reset USART1 */
  RCC->APB2RSTR |= RCC_APB2RSTR_USART1RST;
  RCC->APB2RSTR &= ~RCC_APB2RSTR_USART1RST;
  
  /* PA9(USART1_TX) configure to push pull, PA10(USART1_RX) configure to Input with Pull-up resistance */
  GPIOA->CRH = (GPIOA->CRH & 0xFFFFF00F) | 0x000008B0;
  GPIOA->BSRR = GPIO_BSRR_BS10;
  
  /* Configure USART1 */
  USART1->CR2 = 0x0000;
  USART1->CR1 = USART_CR1_TE | USART_CR1_RE;
  USART1->CR3 = 0x0000;
  USART1->BRR = (apbclk + (baud >> 1)) / baud;    
  
  /* Enable USART1 */
  USART1->CR1 |= USART_CR1_UE;
}


/**
  * @name    uart1_send
  * @brief   Send data through UART1
  * @param   buffer: Buffer to send
  * @param   length: Buffer length
  * @retval  None
  */
void usart1_send(const uint8_t* buffer, uint32_t length)
{
  while(length)
  {
    while(!(USART1->SR & USART_SR_TC));
    USART1->DR = *buffer;
    buffer++;  length--;
  }
  while(!(USART1->SR & USART_SR_TC));
}







