/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"
#include "bsp_usart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t KeyAES[16] = {0xe5,0x7f,0x4d,0x02,0xb2,0xa7,0x6a,0x2e,0xec,0x01,0x85,0x9d,0x9a,0x48,0x01,0x7c};

uint8_t PlainData[16] = {0xe1,0x6c,0x76,0x07,0x36,0x32,0x12,0xa4,0x49,0x7d,0xeb,0x33,0x98,0xde,0x1a,0xef};

uint8_t CypherData[16] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

uint8_t Expected_Value[16] = {0xf7,0x35,0xdb,0xb8,0x59,0xf1,0x03,0xd9,0xc8,0xae,0xcd,0x5a,0x9f,0xf3,0x92,0xae};

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
 * @brief  Main program.
 * @param  None
 * @return None
 */
int main(void)
{
  NVIC_InitTypeDef NVIC_Struct;
  AES_InitTypeDef AES_Init_Struct;

  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_AES, ENABLE);

  /* Init usart1 */
  usart1_init(SystemCoreClock, 115200);
  
  uint8_t flag_ecb = 1;
  uint32_t Ilength = 16;
  uint32_t index = 0;
  uint32_t *inputaddr  = (uint32_t*)PlainData;
  uint32_t *outputaddr = (uint32_t*)CypherData;
  
  /* Configure AES IRQ */
  NVIC_Struct.NVIC_IRQChannel = AES_IRQn;
  NVIC_Struct.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Struct.NVIC_IRQChannelPreemptionPriority = 1;
  NVIC_Struct.NVIC_IRQChannelSubPriority = 1;
  NVIC_Init(&NVIC_Struct);
  
  /* Configure AES as seleted mode */
  AES_Init_Struct.AES_CHMOD = AES_CHMOD_ECB;
  AES_Init_Struct.AES_DATATYPE = AES_DATATYPE_8Bits;
  AES_Init_Struct.AES_MODE = AES_MODE_Encryption;
  AES_Init(&AES_Init_Struct);
  
  /* Enable AES CCF interruption */
  AES_IT_Config(AES_IT_CCF, ENABLE);
  
  /* Set AES key */
  AES_SetKey (KeyAES);
  
  /* Enable AES */
  AES_Cmd(ENABLE);
  
  /* Fill input data and get output data */
  for(index = 0; index < Ilength; index += 16)
  {
    /* Write the Input block in the Data Input register */
    AES_DataInput(inputaddr);
    
    /* Wait for calculation completly */
    SysTick_Delay_Ms(100);
    
    /* Get the Output block from the Data Output register */
    AES_DataOutput(outputaddr);
  }
  
  /* Check if the calculation result is right */
  for(index = 0; index < 16 ; index++)
  {
    if(Expected_Value[index] != CypherData[index])
    {
      flag_ecb = 0;
      break;
    }
  }
  
  /* printf the verification result */
  if(!flag_ecb)
  {
    printf("ECB encryption error!\r\n");
  }
  else
  {
    printf("ECB encryption success!\r\n");
  }
  
  /* Infinite loop */
  while(1)
  {
  }
}

/**
 * @brief  This function handles AES interrupt request.
 * @param  None
 * @return None
 */
void AES_IRQHandler(void)
{
  if(AES_GetFlagStatus(AES_FLAG_CCF)!= RESET)
  {
    AES_ClearFlag(AES_FLAG_CCF);  
    printf("ECB encryption calculation completly!\r\n");
  }
}

#ifdef  USE_FULL_ASSERT
/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param  file: pointer to the source file name
 * @param  line: assert_param error line source number
 * @return None
 */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
