/**
 * @file    mg32f157_crc.c
 * @author  MegawinTech Application Team
 * @version V0.0.4
 * @date    16-June-2023
 * @brief   This file provides all the CRC firmware functions.
 */

/* Includes ------------------------------------------------------------------*/
#include "mg32f157_crc.h"

/** @addtogroup MG32F157_StdPeriph_Driver
  * @{
  */

/** @defgroup CRC 
  * @brief CRC driver modules
  * @{
  */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/** @defgroup CRC_Private_Functions
  * @{
  */

/**
 * @brief  Resets the CRC Data register (DR).
 * @param  None
 * @return None
 */
void CRC_ResetDR(void)
{
  /* Reset CRC generator */
  CRC->CR = CRC_CR_RESET;
}

/**
 * @brief  Computes the 32-bit CRC of a given data word(32-bit).
 * @param  Data: data word(32-bit) to compute its CRC.
 * @return 32-bit CRC
 */
uint32_t CRC_CalcCRC(uint32_t Data)
{
  CRC->DR = Data;
  
  return (CRC->DR);
}

/**
 * @brief  Computes the 32-bit CRC of a given buffer of data word(32-bit).
 * @param  pBuffer: pointer to the buffer containing the data to be computed.
 * @param  BufferLength: length of the buffer to be computed.
 * @return 32-bit CRC
 */
uint32_t CRC_CalcBlockCRC(uint32_t pBuffer[], uint32_t BufferLength)
{
  uint32_t index = 0;
  
  for(index = 0; index < BufferLength; index++)
  {
    CRC->DR = pBuffer[index];
  }
  return (CRC->DR);
}

/**
 * @brief  Returns the current CRC value.
 * @param  None
 * @return 32-bit CRC
 */
uint32_t CRC_GetCRC(void)
{
  return (CRC->DR);
}

/**
 * @brief  Stores a 8-bit data in the Independent Data(ID) register.
 * @param  IDValue: 8-bit value to be stored in the ID register.
 * @return None
 */
void CRC_SetIDRegister(uint8_t IDValue)
{
  CRC->IDR = IDValue;
}

/**
 * @brief  Returns the 8-bit data stored in the Independent Data(ID) register.
 * @param  None
 * @return 8-bit value of the ID register.
 */
uint8_t CRC_GetIDRegister(void)
{
  return (CRC->IDR);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
