/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"
#include "bsp_usart1.h"
#include <stdio.h>
#include <string.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t KeyAES[16] = {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c};

uint8_t PlainData[16] = {0xae,0x2d,0x8a,0x57,0x1e,0x03,0xac,0x9c,0x9e,0xb7,0x6f,0xac,0x45,0xaf,0x8e,0x51};

uint8_t CypherData[16] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

uint8_t InitVectAES[16] = {0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xff,0x00};

uint8_t Expected_Value[64] = {0x98,0x06,0xf6,0x6b,0x79,0x70,0xfd,0xff,0x86,0x17,0x18,0x7b,0xb9,0xff,0xfd,0xff};

uint32_t DmaTempt[4] = {0};
uint8_t flag_crt = 1;
uint32_t Ilength = 16;

/* Private function prototypes -----------------------------------------------*/
void AES_DMAOUT_Init(void);
void AES_DMAIN_Init(void);

/* Private functions ---------------------------------------------------------*/

/**
 * @brief  Main program.
 * @param  None
 * @note   Selects function AES_DMAIN_Init() or AES_DMAOUT_Init()
           to test the AES input or output DMA request.
 * @return None
 */
int main(void)
{
  /* Clear the DmaTempt buffer */
  memset(DmaTempt, 0, sizeof(DmaTempt));
  /* Init usart1 */
  usart1_init(SystemCoreClock, 115200);
  
  AES_DMAIN_Init();
//  AES_DMAOUT_Init();

  /* Infinite loop */
  while(1)
  {
  }
}

/**
 * @brief  This function tests AES input DMA request.
 * @param  None
 * @return None
 */
void AES_DMAIN_Init(void)
{
  DMAC_Channel_InitTypeDef DMAC_Channel_InitStruct;
  AES_InitTypeDef AES_Init_Struct;
  
  uint32_t index = 0;
  uint32_t *outputaddr = (uint32_t *)CypherData;
  
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_AES, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMAC1, ENABLE);
  
  /* DMAC1 configuration */
  DMAC_DeInit(DMAC1);
  DMAC_Channel_InitStruct.DMAC_SourceBaseAddr = (uint32_t)PlainData;
  DMAC_Channel_InitStruct.DMAC_DestinationBaseAddr = (uint32_t)&(AES->DINR);
  DMAC_Channel_InitStruct.DMAC_Interrupt = DMAC_Interrupt_Disable;
  DMAC_Channel_InitStruct.DMAC_SourceTransferWidth = DMAC_SourceTransferWidth_32b;
  DMAC_Channel_InitStruct.DMAC_DestinationTransferWidth = DMAC_DestinationTransferWidth_32b;
  DMAC_Channel_InitStruct.DMAC_SourceAddrInc = DMAC_SourceAddrInc_Increment;
  DMAC_Channel_InitStruct.DMAC_DestinationAddrInc = DMAC_DestinationAddrInc_NoChange;
  DMAC_Channel_InitStruct.DMAC_SourceTransactionLength = DMAC_SourceTransactionLength_1;
  DMAC_Channel_InitStruct.DMAC_DestinationTransactionLength = DMAC_DestinationTransactionLength_1;
  DMAC_Channel_InitStruct.DMAC_TransferTypeAndFlowControl = DMAC_TransferTypeAndFlowControl_MemoryToPeripheral_DMAC;
  DMAC_Channel_InitStruct.DMAC_BlockTransferSize = 4;
  DMAC_Channel_InitStruct.DMAC_SourceHandshakingInterfaceSelect = DMAC_SourceHandshakingInterfaceSelect_Hardware;
  DMAC_Channel_InitStruct.DMAC_DestinationHandshakingInterfaceSelect = DMAC_DestinationHandshakingInterfaceSelect_Hardware;
  DMAC_Channel_InitStruct.DMAC_SourceHandshakingInterfacePolarity = DMAC_SourceHandshakingInterfacePolarity_High;
  DMAC_Channel_InitStruct.DMAC_DestinationHandshakingInterfacePolarity = DMAC_DestinationHandshakingInterfacePolarity_High;
  DMAC_Channel_InitStruct.DMAC_AutomaticSourceReload = DMAC_AutomaticSourceReload_Disable;
  DMAC_Channel_InitStruct.DMAC_AutomaticDestinationReload = DMAC_AutomaticDestinationReload_Disable;
  DMAC_Channel_InitStruct.DMAC_FlowControlMode = DMAC_FlowControlMode_0;
  DMAC_Channel_InitStruct.DMAC_FIFOMode = DMAC_FIFOMode_0;
  DMAC_Channel_InitStruct.DMAC_ChannelPriority = 0;
  DMAC_Channel_InitStruct.DMAC_ProtectionControl = 0x1;
  DMAC_Channel_InitStruct.DMAC_SourceHardwareHandshakingInterfaceAssign = DMAC_HardwareHandshakingInterface_ADC1__TIM2_CH3__TIM4_CH1__QSPI0__AES_RX;
  DMAC_Channel_InitStruct.DMAC_DestinationHardwareHandshakingInterfaceAssign = 0;
  DMAC_Channel_InitStruct.DMAC_MaximumAMBABurstLength = 0;
  DMAC_Channel_Init(DMAC1, DMAC_Channel_2, &DMAC_Channel_InitStruct);

  /* Enable DMAC1 for Channel 2 */
  DMAC_Cmd(DMAC1, ENABLE);
  DMAC_ChannelCmd(DMAC1, DMAC_Channel_2, ENABLE);
  
  /* Configure AES as seleted mode */
  AES_Init_Struct.AES_CHMOD = AES_CHMOD_CTR;
  AES_Init_Struct.AES_DATATYPE = AES_DATATYPE_8Bits;
  AES_Init_Struct.AES_MODE = AES_MODE_Encryption;
  AES_Init(&AES_Init_Struct);
  
  /* Enable AES input DMA */
  AES_DMA_Cmd(AES_DMA_IN, ENABLE);
  /* Set AES key */
  AES_SetKey (KeyAES);
  /* Set AES vector table */
  AES_SetInitVector (InitVectAES);
  /* ENABLE AES */
  AES_Cmd(ENABLE);
  
  /* Fill input data and get output data */
  for(index = 0; index < Ilength; index += 16)
  {
    /* Wait for AES input DMA request and then DMA transmit data from PlainData buffer 
       to the Input block in the Data Input register(AES->DINR) automatically. */
    
    /* Wait for calculation completly */
    SysTick_Delay_Ms(100);
    
    /* Get the Output block from the Data Output register */
    AES_DataOutput(outputaddr + index / 4);
  }
  
  /* Check if the calculation result is right */
  for(index = 0; index < 16 ; index++)
  {
    if(Expected_Value[index] != CypherData[index])
    {
      flag_crt = 0;
      break;
    }
  }
  
  /* printf the verification result */
  if(!flag_crt)
  {
    printf("CRT encryption DMA IN error !\r\n");
  }
  else
  {
   printf("CRT encryption DMA IN success !\r\n");
  }
}

/**
 * @brief  This function tests AES output DMA request.
 * @param  None
 * @return None
 */
void AES_DMAOUT_Init(void)
{
  DMAC_Channel_InitTypeDef DMAC_Channel_InitStruct;
  AES_InitTypeDef AES_Init_Struct;
  
  uint32_t index = 0;
  uint32_t *inputaddr  = (uint32_t *)PlainData;
  uint32_t *outputaddr = (uint32_t *)CypherData;
  
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_AES, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMAC1, ENABLE);
  
  DMAC_DeInit(DMAC1);
  DMAC_Channel_InitStruct.DMAC_SourceBaseAddr = (uint32_t)&(AES->DOUTR);
  DMAC_Channel_InitStruct.DMAC_DestinationBaseAddr = (uint32_t)(DmaTempt);
  DMAC_Channel_InitStruct.DMAC_Interrupt = DMAC_Interrupt_Disable;
  DMAC_Channel_InitStruct.DMAC_SourceTransferWidth = DMAC_SourceTransferWidth_32b;
  DMAC_Channel_InitStruct.DMAC_DestinationTransferWidth = DMAC_DestinationTransferWidth_32b;
  DMAC_Channel_InitStruct.DMAC_SourceAddrInc = DMAC_SourceAddrInc_NoChange;
  DMAC_Channel_InitStruct.DMAC_DestinationAddrInc = DMAC_DestinationAddrInc_Increment;
  DMAC_Channel_InitStruct.DMAC_SourceTransactionLength = DMAC_SourceTransactionLength_1;
  DMAC_Channel_InitStruct.DMAC_DestinationTransactionLength = DMAC_DestinationTransactionLength_1;
  DMAC_Channel_InitStruct.DMAC_TransferTypeAndFlowControl = DMAC_TransferTypeAndFlowControl_PeripheralToMemory_DMAC;
  DMAC_Channel_InitStruct.DMAC_BlockTransferSize = 4;
  DMAC_Channel_InitStruct.DMAC_SourceHandshakingInterfaceSelect = DMAC_SourceHandshakingInterfaceSelect_Hardware;
  DMAC_Channel_InitStruct.DMAC_DestinationHandshakingInterfaceSelect = DMAC_DestinationHandshakingInterfaceSelect_Hardware;
  DMAC_Channel_InitStruct.DMAC_SourceHandshakingInterfacePolarity = DMAC_SourceHandshakingInterfacePolarity_High;
  DMAC_Channel_InitStruct.DMAC_DestinationHandshakingInterfacePolarity = DMAC_DestinationHandshakingInterfacePolarity_High;
  DMAC_Channel_InitStruct.DMAC_AutomaticSourceReload = DMAC_AutomaticSourceReload_Disable;
  DMAC_Channel_InitStruct.DMAC_AutomaticDestinationReload = DMAC_AutomaticDestinationReload_Disable;
  DMAC_Channel_InitStruct.DMAC_FlowControlMode = DMAC_FlowControlMode_0;
  DMAC_Channel_InitStruct.DMAC_FIFOMode = DMAC_FIFOMode_0;
  DMAC_Channel_InitStruct.DMAC_ChannelPriority = 0;
  DMAC_Channel_InitStruct.DMAC_ProtectionControl = 0x1;
  DMAC_Channel_InitStruct.DMAC_SourceHardwareHandshakingInterfaceAssign = DMAC_HardwareHandshakingInterface_USART3_TX__TIM1_CH1__TIM2_UP__TIM3_CH3__SPI1_RX__AES_TX;
  DMAC_Channel_InitStruct.DMAC_DestinationHardwareHandshakingInterfaceAssign = 0;
  DMAC_Channel_InitStruct.DMAC_MaximumAMBABurstLength = 0;
  DMAC_Channel_Init(DMAC1, DMAC_Channel_3, &DMAC_Channel_InitStruct);

  /* Enable DMAC1 for Channel 3 */
  DMAC_Cmd(DMAC1, ENABLE);
  DMAC_ChannelCmd(DMAC1, DMAC_Channel_3, ENABLE);
  
  /* Configure AES as seleted mode */
  AES_Init_Struct.AES_CHMOD = AES_CHMOD_CTR;
  AES_Init_Struct.AES_DATATYPE = AES_DATATYPE_8Bits;
  AES_Init_Struct.AES_MODE = AES_MODE_Encryption;
  AES_Init(&AES_Init_Struct);
  
  /* Enable AES output DMA */
  AES_DMA_Cmd(AES_DMA_OUT, ENABLE);
  /* Set AES key */
  AES_SetKey (KeyAES);
  /* Set AES vector table */
  AES_SetInitVector (InitVectAES);
  /* ENABLE AES */
  AES_Cmd(ENABLE);
  
  /* Fill input data and get output data */
  for(index = 0; index < Ilength; index += 16)
  {
    /* Write the Input block in the Data Input register */
    AES_DataInput(inputaddr + index / 4);
    
    /* Wait for calculation completly */
    SysTick_Delay_Ms(100);

    /* Wait for AES output DMA request and then transmit data from 
       the Output block in the Data Output register to DmaTempt buffer by DMA. */
    
    /* Once the output DMA request was responsed, the DmaTempt buffer will be full with encrypted datas.
       Get datas from DmaTempt buffer and compare with the expected value to test the output DMA request. */
   *(outputaddr) = DmaTempt[0];
    outputaddr++;
   *(outputaddr) = DmaTempt[1];
    outputaddr++;
   *(outputaddr) = DmaTempt[2];
    outputaddr++;
   *(outputaddr) = DmaTempt[3];
    outputaddr++;
  }
  
  /* Check if the calculation result is right */
  for(index = 0; index < 16 ; index++)
  {
    if(Expected_Value[index] != CypherData[index])
    {
      flag_crt = 0;
      break;
    }
  }
  
  /* printf the verification result */
  if(!flag_crt)
  {
    printf("CRT encryption DAM OUT error !\r\n");
  }
  else
  {
    printf("CRT encryption DAM OUT success !\r\n");
  }
}

#ifdef  USE_FULL_ASSERT
/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param  file: pointer to the source file name
 * @param  line: assert_param error line source number
 * @return None
 */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
