/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"
#include "bsp_usart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t KeyAES[16] = { 0xc6,0x70,0x32,0xd7,0x9a,0xe9,0x22,0x37,0x2c,0x60,0x79,0x3e,0x32,0x40,0x46,0xd2};

uint8_t InitVectAES[16] = {0x5b,0xdf,0x8b,0x52,0x4b,0x65,0x35,0xe2,0x32,0x28,0xc3,0xec,0x32,0x11,0x8c,0x40};

uint8_t PlainData[48] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

uint8_t CypherData[] = {0xd7,0x03,0x34,0x38,0x63,0xc4,0xea,0x7b,0x7b,0xfd,0xb4,0x64,0xcd,0x47,0x48,0x1d,0xf6,0x68,0xf6,0x3d,0x70,0x47,0x74,0x03,
                        0xf2,0xd2,0x31,0x07,0x7c,0x26,0x1c,0xb5,0xdc,0xbe,0xd0,0x8e,0x08,0x9f,0x1b,0x8c,0x29,0x12,0xd7,0x42,0x41,0x25,0x3f,0x9f};

uint8_t Expected_Value[] = {0xb5,0x25,0xa2,0xb3,0x13,0xa6,0x89,0xfc,0x7c,0xe0,0xba,0x09,0xb6,0x50,0x51,0xd5,0xe1,0x67,0x85,0x0c,0x07,0xd5,0xda,0x6f,
                            0xf4,0x07,0x97,0x7a,0x48,0xee,0x7b,0x44,0xca,0x03,0xac,0xa8,0xff,0x88,0xf0,0xa2,0xfc,0x10,0x1f,0xfb,0x78,0x41,0xd9,0x29};

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
 * @brief  Main program.
 * @param  None
 * @return None
 */
int main(void)
{
  AES_InitTypeDef AES_InitStruct;
  
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_AES, ENABLE);
  
  /* Init usart1 */
  usart1_init(96000000, 115200);
  
  uint8_t flag_cbc = 1;
  uint32_t Ilength = 48;
  uint32_t index = 0;
  uint32_t *inputaddr  = (uint32_t *)CypherData;
  uint32_t *outputaddr = (uint32_t *)PlainData;
  
  /* Configure AES as seleted mode */
  AES_InitStruct.AES_CHMOD = AES_CHMOD_CBC;
  AES_InitStruct.AES_DATATYPE = AES_DATATYPE_8Bits;
  AES_InitStruct.AES_MODE = AES_MODE_Derivation_Decryption;
  AES_Init(&AES_InitStruct);
  
  /* Set AES key */
  AES_SetKey(KeyAES);
  /* Set AES vetor table */
  AES_SetInitVector(InitVectAES);
  /* Enable AES */
  AES_Cmd(ENABLE);
  
  /* Fill input data and get output data */
  for(index = 0; index < Ilength; index += 16)
  {
    /* Write the Input block in the Data Input register */
    AES_DataInput(inputaddr + index / 4);
    
    /* Wait for calculation completly */
    SysTick_Delay_Ms(100);

    /* Get the Output block from the Data Output register */
    AES_DataOutput(outputaddr + index / 4);
  }

  /* Check if the calculation result is right */
  for(index = 0; index < 48 ; index++)
  {
    if(Expected_Value[index] != PlainData[index])
    {
      flag_cbc = 0;
      break;
    }
  }
  
  /* printf the verification result */
  if(!flag_cbc)
  {
    printf("CBC decryption and derivation error!\r\n");
  }
  else
  {
    printf("CBC decryption and derivation success!\r\n");
  }
  
  /* Infinite loop */
  while(1)
  {
  }
}


#ifdef  USE_FULL_ASSERT
/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param  file: pointer to the source file name
 * @param  line: assert_param error line source number
 * @return None
 */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
