#ifndef __DRV_QSPI_H
#define __DRV_QSPI_H

#include "mg32f157.h"

/* Instructions */
#define INS_WriteEnable          0x06
#define INS_WriteDisable         0x04
#define INS_ReadStatusReg1       0x05
#define INS_ReadStatusReg2       0x35
#define INS_ReadStatusReg3       0x15
#define INS_WriteStatusReg1      0x01
#define INS_WriteStatusReg2      0x31
#define INS_WriteStatusReg3      0x11
#define INS_ReadData             0x03
#define INS_QuadInputPageProgram 0x32
#define INS_FastReadQual         0xBB
#define INS_FastReadQuad         0xEB
#define INS_FastReadData         0x0B
#define INS_FastReadDual         0x3B
#define INS_PageProgram          0x02
#define INS_BlockErase           0xD8
#define INS_SectorErase          0x20
#define INS_ChipErase            0xC7
#define INS_PowerDown            0xB9
#define INS_ReleasePowerDown     0xAB
#define INS_DeviceID             0xAB
#define INS_ManufactDeviceID     0x90
#define INS_ManufactDeviceIDQual 0x92
#define INS_ManufactDeviceIDQSPI 0x94
#define INS_JedecDeviceID        0x9F
#define INS_Enable4ByteAddr      0xB7
#define INS_Exit4ByteAddr        0xE9
#define INS_SetReadParam         0xC0
#define INS_EnterQPIMode         0x38
#define INS_ExitQPIMode          0xFF

/* Default dummy clocks cycles */
#define DUMMY_CLOCK_CYCLES_READ              8
#define DUMMY_CLOCK_CYCLES_READ_QUAD         16
#define DUMMY_CLOCK_CYCLES_READ_DTR          6
#define DUMMY_CLOCK_CYCLES_READ_QUAD_DTR     8

/* Timeout default value */
#define QSPI_TIMEOUT_DEFAULT                 ((uint32_t)0x2FFFFFF)

void SpiFlash_Init(void);
void QSPI_WriteEnable(void);
void QSPI_Receive_IT(void);
void QSPI_Transmit_IT(void);
uint32_t SpiFlash_ReadIdentification(void);
uint16_t SpiFlash_QuadReadMidDid(void);
void SpiFlash_WaitReady(void);
void SpiFlash_ChipErase(void);
void SpiFlash_SectorErase(uint32_t address);
void SpiFlash_QuadFastRead(uint32_t address, uint8_t* buffer, uint32_t length);
void SpiFlash_QuadPageProgram(uint32_t address, const uint8_t* buffer, uint16_t length);
void SpiFlash_QuadWriteBuffer(uint32_t address, const uint8_t* buffer, uint32_t length);
uint8_t SpiFlash_ReadStatusReg1(void);
uint8_t SpiFlash_ReadStatusReg2(void);
uint8_t SpiFlash_ReadStatusReg3(void);

/* Exported macro ------------------------------------------------------------*/

#endif /* __DRV_QSPI_H */

