;/**************************************************************************//**
; * @file     startup_mg32f157.s
; * @brief    CMSIS Core Device Startup File for
; *           MG32F157 Device
; * @version  V0.0.4
; * @date     16-June-2023
; ******************************************************************************/
;/*
; * Copyright (c) 2009-2018 Arm Limited. All rights reserved.
; *
; * SPDX-License-Identifier: Apache-2.0
; *
; * Licensed under the Apache License, Version 2.0 (the License); you may
; * not use this file except in compliance with the License.
; * You may obtain a copy of the License at
; *
; * www.apache.org/licenses/LICENSE-2.0
; *
; * Unless required by applicable law or agreed to in writing, software
; * distributed under the License is distributed on an AS IS BASIS, WITHOUT
; * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; * See the License for the specific language governing permissions and
; * limitations under the License.
; */

;
; The modules in this file are included in the libraries, and may be replaced
; by any user-defined modules that define the PUBLIC symbol _program_start or
; a user defined start symbol.
; To override the cstartup defined in the library, simply add your modified
; version to the workbench project.
;
; The vector table is normally located at address 0.
; When debugging in RAM, it can be located in RAM, aligned to at least 2^6.
; The name "__vector_table" has special meaning for C-SPY:
; it is where the SP start value is found, and the NVIC vector
; table register (VTOR) is initialized to this address if != 0.
;
; Cortex-M version
;

                MODULE   ?cstartup

                ;; Forward declaration of sections.
                SECTION  CSTACK:DATA:NOROOT(3)

                SECTION  .intvec:CODE:NOROOT(2)

                EXTERN   __iar_program_start
                EXTERN   SystemInit
                PUBLIC   __vector_table
                PUBLIC   __vector_table_0x1c
                PUBLIC   __Vectors
                PUBLIC   __Vectors_End
                PUBLIC   __Vectors_Size

                DATA

__vector_table
                DCD      sfe(CSTACK)                         ;     Top of Stack
                DCD      Reset_Handler                       ;     Reset Handler
                DCD      NMI_Handler                         ; -14 NMI Handler
                DCD      HardFault_Handler                   ; -13 Hard Fault Handler
                DCD      MemManage_Handler                   ; -12 MPU Fault Handler
                DCD      BusFault_Handler                    ; -11 Bus Fault Handler
                DCD      UsageFault_Handler                  ; -10 Usage Fault Handler
__vector_table_0x1c
                DCD      0                                   ;     Reserved
                DCD      0                                   ;     Reserved
                DCD      0                                   ;     Reserved
                DCD      0                                   ;     Reserved
                DCD      SVC_Handler                         ;  -5 SVCall Handler
                DCD      DebugMon_Handler                    ;  -4 Debug Monitor Handler
                DCD      0                                   ;     Reserved
                DCD      PendSV_Handler                      ;  -2 PendSV Handler
                DCD      SysTick_Handler                     ;  -1 SysTick Handler

                ; Interrupts
                DCD     WWDG_IRQHandler                      ;   0 Window Watchdog
                DCD     PVD_IRQHandler                       ;   1 PVD through EXTI Line detect
                DCD     TAMPER_IRQHandler                    ;   2 Tamper
                DCD     RTC_IRQHandler                       ;   3 RTC
                DCD     FLASH_IRQHandler                     ;   4 Flash
                DCD     RCC_IRQHandler                       ;   5 RCC
                DCD     EXTI0_IRQHandler                     ;   6 EXTI Line 0
                DCD     EXTI1_IRQHandler                     ;   7 EXTI Line 1
                DCD     EXTI2_IRQHandler                     ;   8 EXTI Line 2
                DCD     EXTI3_IRQHandler                     ;   9 EXTI Line 3
                DCD     EXTI4_IRQHandler                     ;  10 EXTI Line 4
                DCD     DMA1_Channel1_IRQHandler             ;  11 DMA1 Channel 1
                DCD     DMA1_Channel2_IRQHandler             ;  12 DMA1 Channel 2
                DCD     DMA1_Channel3_IRQHandler             ;  13 DMA1 Channel 3
                DCD     DMA1_Channel4_IRQHandler             ;  14 DMA1 Channel 4
                DCD     DMA1_Channel5_IRQHandler             ;  15 DMA1 Channel 5
                DCD     DMA1_Channel6_IRQHandler             ;  16 DMA1 Channel 6
                DCD     DMA1_Channel7_IRQHandler             ;  17 DMA1 Channel 7
                DCD     ADC1_2_IRQHandler                    ;  18 ADC1 & ADC2
                DCD     USB_DMA_CAN1_IRQHandler              ;  19 USB DMA or CAN1
                DCD     USB_IRQHandler                       ;  20 USB
                DCD     0                                    ;     Reserved
                DCD     0                                    ;     Reserved
                DCD     EXTI9_5_IRQHandler                   ;  23 EXTI Line 9..5
                DCD     TIM1_BRK_IRQHandler                  ;  24 TIM1 Break
                DCD     TIM1_UP_IRQHandler                   ;  25 TIM1 Update
                DCD     TIM1_TRG_COM_IRQHandler              ;  26 TIM1 Trigger and Commutation
                DCD     TIM1_CC_IRQHandler                   ;  27 TIM1 Capture Compare
                DCD     TIM2_IRQHandler                      ;  28 TIM2
                DCD     TIM3_IRQHandler                      ;  29 TIM3
                DCD     TIM4_IRQHandler                      ;  30 TIM4
                DCD     I2C1_EV_IRQHandler                   ;  31 I2C1 Event
                DCD     I2C1_ER_IRQHandler                   ;  32 I2C1 Error
                DCD     I2C2_EV_IRQHandler                   ;  33 I2C2 Event
                DCD     I2C2_ER_IRQHandler                   ;  34 I2C2 Error
                DCD     SPI1_IRQHandler                      ;  35 SPI1
                DCD     SPI2_IRQHandler                      ;  36 SPI2
                DCD     USART1_IRQHandler                    ;  37 USART1
                DCD     USART2_IRQHandler                    ;  38 USART2
                DCD     USART3_IRQHandler                    ;  39 USART3
                DCD     EXTI15_10_IRQHandler                 ;  40 EXTI Line 15..10
                DCD     RTCAlarm_IRQHandler                  ;  41 RTC Alarm through EXTI Line
                DCD     0                                    ;     Reserved
                DCD     TIM8_BRK_IRQHandler                  ;  43 TIM8 Break
                DCD     TIM8_UP_IRQHandler                   ;  44 TIM8 Update
                DCD     TIM8_TRG_COM_IRQHandler              ;  45 TIM8 Trigger and Commutation
                DCD     TIM8_CC_IRQHandler                   ;  46 TIM8 Capture Compare
                DCD     ADC3_IRQHandler                      ;  47 ADC3
                DCD     0                                    ;     Reserved
                DCD     SDIO_IRQHandler                      ;  49 SDIO
                DCD     TIM5_IRQHandler                      ;  50 TIM5
                DCD     SPI3_IRQHandler                      ;  51 SPI3
                DCD     UART4_IRQHandler                     ;  52 UART4
                DCD     UART5_IRQHandler                     ;  53 UART5
                DCD     TIM6_IRQHandler                      ;  54 TIM6
                DCD     TIM7_IRQHandler                      ;  55 TIM7
                DCD     DMA2_Channel1_IRQHandler             ;  56 DMA2 Channel1
                DCD     DMA2_Channel2_IRQHandler             ;  57 DMA2 Channel2
                DCD     DMA2_Channel3_IRQHandler             ;  58 DMA2 Channel3
                DCD     DMA2_Channel4_5_IRQHandler           ;  59 DMA2 Channel4 & Channel5
                DCD     QUADSPI_IRQHandler                   ;  60 QUADSPI
                DCD     RNG_IRQHandler                       ;  61 RNG
                DCD     AES_IRQHandler                       ;  62 AES
                DCD     USART_EXTI_IRQHandler                ;  63 USART wakeup EXTI
__Vectors_End

__Vectors       EQU      __vector_table
__Vectors_Size  EQU      __Vectors_End - __Vectors


                THUMB

; Reset Handler

                PUBWEAK  Reset_Handler
                SECTION  .text:CODE:REORDER:NOROOT(2)
Reset_Handler
                LDR      R0, =SystemInit
                BLX      R0
                LDR      R0, =__iar_program_start
                BX       R0


                PUBWEAK NMI_Handler
                PUBWEAK HardFault_Handler
                PUBWEAK MemManage_Handler
                PUBWEAK BusFault_Handler
                PUBWEAK UsageFault_Handler
                PUBWEAK SVC_Handler
                PUBWEAK DebugMon_Handler
                PUBWEAK PendSV_Handler
                PUBWEAK SysTick_Handler

                PUBWEAK WWDG_IRQHandler           
                PUBWEAK PVD_IRQHandler            
                PUBWEAK TAMPER_IRQHandler         
                PUBWEAK RTC_IRQHandler            
                PUBWEAK FLASH_IRQHandler          
                PUBWEAK RCC_IRQHandler            
                PUBWEAK EXTI0_IRQHandler          
                PUBWEAK EXTI1_IRQHandler          
                PUBWEAK EXTI2_IRQHandler          
                PUBWEAK EXTI3_IRQHandler          
                PUBWEAK EXTI4_IRQHandler          
                PUBWEAK DMA1_Channel1_IRQHandler  
                PUBWEAK DMA1_Channel2_IRQHandler  
                PUBWEAK DMA1_Channel3_IRQHandler  
                PUBWEAK DMA1_Channel4_IRQHandler  
                PUBWEAK DMA1_Channel5_IRQHandler  
                PUBWEAK DMA1_Channel6_IRQHandler  
                PUBWEAK DMA1_Channel7_IRQHandler  
                PUBWEAK ADC1_2_IRQHandler         
                PUBWEAK USB_DMA_CAN1_IRQHandler   
                PUBWEAK USB_IRQHandler            
                PUBWEAK EXTI9_5_IRQHandler        
                PUBWEAK TIM1_BRK_IRQHandler       
                PUBWEAK TIM1_UP_IRQHandler        
                PUBWEAK TIM1_TRG_COM_IRQHandler   
                PUBWEAK TIM1_CC_IRQHandler        
                PUBWEAK TIM2_IRQHandler           
                PUBWEAK TIM3_IRQHandler           
                PUBWEAK TIM4_IRQHandler           
                PUBWEAK I2C1_EV_IRQHandler        
                PUBWEAK I2C1_ER_IRQHandler        
                PUBWEAK I2C2_EV_IRQHandler        
                PUBWEAK I2C2_ER_IRQHandler        
                PUBWEAK SPI1_IRQHandler           
                PUBWEAK SPI2_IRQHandler           
                PUBWEAK USART1_IRQHandler         
                PUBWEAK USART2_IRQHandler         
                PUBWEAK USART3_IRQHandler         
                PUBWEAK EXTI15_10_IRQHandler      
                PUBWEAK RTCAlarm_IRQHandler       
                PUBWEAK TIM8_BRK_IRQHandler       
                PUBWEAK TIM8_UP_IRQHandler        
                PUBWEAK TIM8_TRG_COM_IRQHandler   
                PUBWEAK TIM8_CC_IRQHandler        
                PUBWEAK ADC3_IRQHandler         
                PUBWEAK SDIO_IRQHandler           
                PUBWEAK TIM5_IRQHandler           
                PUBWEAK SPI3_IRQHandler           
                PUBWEAK UART4_IRQHandler          
                PUBWEAK UART5_IRQHandler          
                PUBWEAK TIM6_IRQHandler           
                PUBWEAK TIM7_IRQHandler           
                PUBWEAK DMA2_Channel1_IRQHandler  
                PUBWEAK DMA2_Channel2_IRQHandler  
                PUBWEAK DMA2_Channel3_IRQHandler  
                PUBWEAK DMA2_Channel4_5_IRQHandler
                PUBWEAK QUADSPI_IRQHandler        
                PUBWEAK RNG_IRQHandler            
                PUBWEAK AES_IRQHandler            
                PUBWEAK USART_EXTI_IRQHandler     
                SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
HardFault_Handler
MemManage_Handler
BusFault_Handler
UsageFault_Handler
SVC_Handler
DebugMon_Handler
PendSV_Handler
SysTick_Handler

WWDG_IRQHandler           
PVD_IRQHandler            
TAMPER_IRQHandler         
RTC_IRQHandler            
FLASH_IRQHandler          
RCC_IRQHandler            
EXTI0_IRQHandler          
EXTI1_IRQHandler          
EXTI2_IRQHandler          
EXTI3_IRQHandler          
EXTI4_IRQHandler          
DMA1_Channel1_IRQHandler  
DMA1_Channel2_IRQHandler  
DMA1_Channel3_IRQHandler  
DMA1_Channel4_IRQHandler  
DMA1_Channel5_IRQHandler  
DMA1_Channel6_IRQHandler  
DMA1_Channel7_IRQHandler  
ADC1_2_IRQHandler         
USB_DMA_CAN1_IRQHandler   
USB_IRQHandler            
EXTI9_5_IRQHandler        
TIM1_BRK_IRQHandler       
TIM1_UP_IRQHandler        
TIM1_TRG_COM_IRQHandler   
TIM1_CC_IRQHandler        
TIM2_IRQHandler           
TIM3_IRQHandler           
TIM4_IRQHandler           
I2C1_EV_IRQHandler        
I2C1_ER_IRQHandler        
I2C2_EV_IRQHandler        
I2C2_ER_IRQHandler        
SPI1_IRQHandler           
SPI2_IRQHandler           
USART1_IRQHandler         
USART2_IRQHandler         
USART3_IRQHandler         
EXTI15_10_IRQHandler      
RTCAlarm_IRQHandler       
TIM8_BRK_IRQHandler       
TIM8_UP_IRQHandler        
TIM8_TRG_COM_IRQHandler   
TIM8_CC_IRQHandler        
ADC3_IRQHandler         
SDIO_IRQHandler           
TIM5_IRQHandler           
SPI3_IRQHandler           
UART4_IRQHandler          
UART5_IRQHandler          
TIM6_IRQHandler           
TIM7_IRQHandler           
DMA2_Channel1_IRQHandler  
DMA2_Channel2_IRQHandler  
DMA2_Channel3_IRQHandler  
DMA2_Channel4_5_IRQHandler
QUADSPI_IRQHandler        
RNG_IRQHandler            
AES_IRQHandler            
USART_EXTI_IRQHandler     
                B        .


                END
