#include "IEC60730-STL.h"
 
unsigned char Int_freq;
unsigned int RES_Int_freq;
#define Int_freq_lower			8
#define Int_freq_upper			12
bit Int_watch_interrupt_flag;

/*********************************************************************************************/
/*Module name:   Interrupt                                                                      */
/*Function Name: Interrupt_Test_Init                                                               */
/*Parameter:     None                                                                        */
/*Function description: Initialize Interrupt test corresponding flag and variable .              */
/*********************************************************************************************/ 

void Int_Test_Init(void)
{
	Int_freq = 0;
}

/*********************************************************************************************/
/*Module name:   Int                                                                       */
/*Function Name: IntTest                                                                   */
/*Parameter:     None                                                                        */
/*Function description: checks whether the number of interrupts that occurred is within the  */
/*                      predefined range. and it verifies whether interrupts are handled in  */
/*                      time.once interrupt test error is detected, program will run into an */
/*                      infinite loop.                                                       */
/*                      100us interval timer interrupt check if it happens about 10 times in */
/*                      a 1ms interval.                                                      */
/*********************************************************************************************/
unsigned char IntTest(void)
{

	if(Int_freq > Int_freq_upper || Int_freq < Int_freq_lower)
	{
			
		Int_freq = 0;
		Int_watch_interrupt_flag = 0;
		return TEST_FUNC_ERROR;
	}
	
	Int_freq = 0;
	return TEST_NORMAL;
}

