#include "REG_MG82G5Exx.h"
#include "IEC60730-STL.h"
#include <stdio.h>


#define CRC0DAisCRC0DI()        AUXR1 |= (CRCDS1 | CRCDS0)
#define CRC0DAisCRC0SL()        AUXR1 &= ~(CRCDS1 | CRCDS0)
#define CRC0DAisCRC0SH()        AUXR1 &= ~(CRCDS1 | CRCDS0); AUXR1 |= CRCDS0

#define wCRC0SL(wData__)        AUXR1 &= ~(CRCDS1 | CRCDS0); CRC0DA = (wData__)
#define wCRC0SH(wData__)        AUXR1 &= ~(CRCDS1 | CRCDS0); AUXR1 |= CRCDS0; CRC0DA = (wData__)
#define wCRC0DI(wData__)        AUXR1 |= (CRCDS1 | CRCDS0); CRC0DA = (wData__)

#define rCRC0RL(rVariable__)    AUXR1 &= ~(CRCDS1 | CRCDS0); (rVariable__) = CRC0DA
#define rCRC0RH(rVariable__)    AUXR1 &= ~(CRCDS1 | CRCDS0); AUXR1 |= CRCDS0; (rVariable__) = CRC0DA

//code unsigned int crc_table[16]={
//    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
//    0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
//};


unsigned char var;
    union{
        unsigned char B[2];
        unsigned int W;
    } Calculate_CRC_Boundary_Addr;

/*********************************************************************************************/
/*Module name:   MEMORY -> ROM_test(invariable memory)                                       */
/*Function Name: MakeCRCCode                                                                 */
/*Parameter:     Addr_H -> start address, page -> size(unit 512);                            */
/*return:        crc                                                                         */
/*Function description: This function use Hardware CRC to generate CRC-16 CRC16_CCIT_ZERO    */
/*                      code.                                                                */
/*********************************************************************************************/

//unsigned short SWGPL_CRC16_CCITT_D8(unsigned short crc, unsigned char cdata)
//{
//    unsigned short iCrc;
//    unsigned char i;

//    iCrc = ((unsigned short)cdata) << 8;
//    iCrc = iCrc ^ crc;

//    i = 0;
//    do{
//        if ((iCrc & 0x8000) != 0)
//        {
//            iCrc <<= 1;
//            iCrc ^= 0x1021;
//        }
//        else
//            iCrc <<= 1;
//    }while(++i < 8);

//    return iCrc;
//}

//void UART_Send_Byte(unsigned char Dta)
//{
//	S0BUF = Dta;
//	TI0 = 0;
//	while(!TI0);
//}

unsigned int MakeCRCCode(unsigned char Addr_H, unsigned char page)
{
//	unsigned char code *CodePtr;
//	unsigned short SWCRC_Temp = 0;
	unsigned char IAPLB_tmp;
	unsigned char CRC_H, CRC_L, CRC_H_CPL, CRC_L_CPL;
	unsigned char result;
	
    union{
        unsigned int W;
        unsigned char B[2];
    }W_B;

	CRC_H = *((unsigned char code *) 0x79FC);
	CRC_L = *((unsigned char code *) 0x79FD);
	CRC_H_CPL = *((unsigned char code *) 0x79FE);
	CRC_L_CPL = *((unsigned char code *) 0x79FF);
	
	if((CRC_H == 0xFF) && (CRC_L == 0xFF) && (CRC_H_CPL == 0xFF) && (CRC_L_CPL == 0xFF))
		result = 'E';	//CRC data is empty.
	
	
	
	Calculate_CRC_Boundary_Addr.W = 0;
	var = (Addr_H + ((page - 1) << 1));
	Calculate_CRC_Boundary_Addr.W = (var + 2) * 256; 
	
	IAPLB_tmp = PageP_Read(IAPLB);
	PageP_Write(IAPLB, var);
	
//==================  F/W Calculate CRC16  =========================
//    CodePtr = (unsigned char code *)(Addr_H << 8);

//    do{
//        SWCRC_Temp = SWGPL_CRC16_CCITT_D8(SWCRC_Temp, *CodePtr);
//        CodePtr ++;
//    }while(((unsigned short)CodePtr) < Calculate_CRC_Boundary_Addr.W);

//    printf("    CCITT16 AP IAP FW is %X\n\r", SWCRC_Temp);

//==================  H/W Calculate CRC16  =========================
    wCRC0SL(0);
    wCRC0SH(0);
    CRC0DAisCRC0DI();
	
    ISPCR |= ISP_ENABLE;
    IFADRH = Addr_H;
    IFADRL = 0x00;
    IFMT = 0x80;
	
    SCMD = 0x46;
    SCMD = 0xB9;
	
	ISPCR &= ~ISP_ENABLE;

	rCRC0RH(W_B.B[0]);
	rCRC0RL(W_B.B[1]);

	
	
	if(result == 'E')
	{	//CRC data is Empty
		PageP_Write(IAPLB, 0x76);		//default IAPLB
		ISPCR |= ISP_ENABLE;
		IFADRH = 0x79;
		IFADRL = 0xFC;					//the last IAP address
		IFMT = 0x02;					//Program
		IFD = W_B.B[0];
		SCMD = 0x46;
		SCMD = 0xB9;
		IFADRL ++;
		IFD = W_B.B[1];
		SCMD = 0x46;
		SCMD = 0xB9;
		IFADRL ++;
		IFD = ~W_B.B[0];
		SCMD = 0x46;
		SCMD = 0xB9;
		IFADRL ++;
		IFD = ~W_B.B[1];
		SCMD = 0x46;
		SCMD = 0xB9;
		ISPCR &= ~ISP_ENABLE;
	}

	PageP_Write(IAPLB, IAPLB_tmp);

    printf("Automatic CCITT16 AP IAP HW is %X\n\r", W_B.W);   

	return W_B.W;
}

/*********************************************************************************************/
/*Module name:   MEMORY -> ROM_test(invariable memory)                                       */
/*Function Name: CRCTest                                                                     */
/*Parameter:     p_data-> start address; size -> size of data; crc -> original crc data      */
/*return:        0 -> normal                                                                 */
/*               1 -> function error                                                         */
/*               2 -> parameter error                                                        */
/*Function description: This function check if the crc data is same after data writing or    */
/*                      thansmit. If crc error occurs, program will run into an              */
/*                      infinite loop.                                                       */
/*********************************************************************************************/
unsigned char CRCTest(unsigned char Addr_H, unsigned int crc_original)
{
    union{
        unsigned int W;
        unsigned char B[2];
    }W_B;
	
	if(Addr_H < 0)
	{
		return TEST_PARAMETER_ERROR;
	}
	
	
	W_B.B[0] = *((unsigned char code *) 0x79FC);
	W_B.B[1] = *((unsigned char code *) 0x79FD);
	
	if(W_B.W == crc_original)
	{
		return TEST_NORMAL;
	}
	else
	{
		return TEST_FUNC_ERROR;
	}	
}

 