


/**************************************************************************************************
* Flash and EEPROM support unlimited reading of their data, 
* but limit the number of times data can be written.
* EEPROM has a limit on the number of write operations, 
* so be careful not to place the write operation in the loop or other loop executing functions.
**************************************************************************************************/
/**************************************************************************************************
*      The TH244A(mcu :MG32F02U128) internal 128K bytes of FLASH program memory,
* built-in control logic that simulates FLASH as EEPROM
* (It can be set range from 0.5K bytes to 8K bytes ), 
* part of the program FLASH can be divided into data FLASH space according to application needs, 
* and EEPROM-like interface access is realized through the EEPROM controller.
*       When you include library - EEPROM.h in your ino project,
*  as default,you can use 512 bytes flash space as EEPROM fuction.
*/
/**************************************************************************************************
* If you need more EEPROM space, you need to modify the definition of 
* a specified macro: EEPROM_SIZE in library EEPROM.h file. 
* Can't support define EEPROM_SIZE in Arduino sketch .ino file.
* (EEPROM.h file PATH refer to:
*  ......\Arduino15\packages\megawin\hardware\MG32x02z\2.3.0\libraris\EEPROM\src)
* Support set EEPROM_SIZE range from 0.5K to 8K in increments of 0.5K bytes.
* Here the default setting is 512 bytes. You can modify the value to other as following list.
* Unspecify comments when you need to compile.
**************************************************************************************************/
//====Need to modify the definition of a specified macro: EEPROM_SIZE in library //EEPROM.h file.
// Can't  support define EEPROM_SIZE in Arduino sketch .ino file.
//================Support EEPROM_SIZE list begin. =======================
//#define EEPROM_SIZE 512   //default set EEPROM 0.5K   512 bytes
//#define EEPROM_SIZE 1024  // set EEPROM 1K   1024 bytes
//#define EEPROM_SIZE 1536  // set EEPROM 1.5K   1536 bytes
//#define EEPROM_SIZE 2048  // set EEPROM 2K   2048 bytes
//#define EEPROM_SIZE 2560  // set EEPROM 2.5K   2560 bytes
//#define EEPROM_SIZE 3072  // set EEPROM 3K   3072 bytes
//#define EEPROM_SIZE 3584  // set EEPROM 3.5K   3584 bytes
//#define EEPROM_SIZE 4096  // set EEPROM 4K   4096 bytes
//#define EEPROM_SIZE 4608  // set EEPROM 4.5K   4608 bytes
//#define EEPROM_SIZE 5120  // set EEPROM 5K   5120 bytes
//#define EEPROM_SIZE 5632  // set EEPROM 5.5K   5632 bytes
//#define EEPROM_SIZE 6144  // set EEPROM 6K   6144 bytes
//#define EEPROM_SIZE 6656  // set EEPROM 6.5K   6656 bytes
//#define EEPROM_SIZE 7168  // set EEPROM 7K   7168 bytes
//#define EEPROM_SIZE 7680  // set EEPROM 7.5K   7680 bytes
//#define EEPROM_SIZE 8192  // set EEPROM 8K   8192 bytes
//===========Support EEPROM_SIZE list end============





#include <EEPROM.h>

uint32_t RunCount = 0;

void setup() 
{
    Serial.begin(115200);

    // You can set any number up to EEPROM_SIZE (set at 512) from EEPROM.h
    // While what you specify in begin() will limit what you can read/write, "EEPROM" 
    // data will always take up EEPROM_SIZE in RAM.
    
    Serial.println("\r\n\r\n Reboot.......");
    EEPROM.begin(512);

    // Read from "EEPROM"
    uint8_t bootcount = EEPROM.read(0);    //notice: If the new flash. The read data is 0xFF

    // Increase bootcount
    bootcount++;

    // Print boot count
    Serial.println("Boot count: " + String(bootcount));


    // Write new value
    EEPROM.write(0, bootcount);

    // Save a copy to flash
    Serial.println("Backing up \"Boot count\" to flash.");
    EEPROM.toNVS();

    EEPROM.get(4, RunCount);
    Serial.println("Current EEPROM run count: " + String(RunCount));
}

void loop()
{
    static uint32_t sLastTick = 0;
    uint32_t sNewTick = 0;

    sNewTick = millis();
    
    if( (sNewTick - sLastTick)> 1000 )
    {
        sLastTick = sNewTick;
        RunCount++;
        Serial.println("Now run count: " + String(RunCount));
        if( RunCount%10 == 0 )
        {
            // Save a copy to NVS every 10 second
            EEPROM.put(4, RunCount);
            EEPROM.commit();
            Serial.println("Backing up \"Run count\" to flash.");
        }
    }
}
