/*
In wdt_enable (timeout), timeout is the timeout period.
If the  watchdog does not eat after this period, 
the microcontroller will restart or Trigger watchdog interrupt service Routine(ISR). 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  In this example, the microcontroller will reset once watchdog does not eat after timeout period. 
  Here ,
  Timeout period is 2s.
  in loop(), 
  if delay time > 2s, Watchdog timeout ,the microcontroller will reset.
  if delay time < 2s,  
     When USER KEY(46) is LOW(Pressed),can not feed the dog promptly. After 2s,the microcontroller will reset.
     When USER KEY(46) is HIGH(not Pressed),feed the dog promptly.After 2s,the microcontroller will never reset.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
*/
/* 
  In wdt_enable (timeout), timeout is the timeout period.
  If the  watchdog does not eat after this period, 
  the microcontroller will reset or Trigger watchdog interrupt service Routine(ISR). 
   or Trigger watchdog interrupt service Routine(ISR). 
*/

/*
Timeout period as following:
  SLEEP_15MS  = WDTO_15MS,     // watchdog timer  15ms timeout
  SLEEP_30MS  = WDTO_30MS,     // watchdog timer 30ms timeout
  SLEEP_60MS  = WDTO_60MS,     // watchdog timer 60ms timeout
  SLEEP_120MS = WDTO_120MS,    // watchdog timer 120ms timeout
  SLEEP_250MS = WDTO_250MS,    // watchdog timer 250ms timeout
  SLEEP_500MS = WDTO_500MS,    // watchdog timer 500ms timeout
  SLEEP_1S    = WDTO_1S,       // watchdog timer 1s timeout
  SLEEP_2S    = WDTO_2S,       // watchdog timer 2s timeout
  SLEEP_4S    = WDTO_4S,       // watchdog timer 4s timeout
  SLEEP_8S    = WDTO_8S,       // watchdog timer 8s timeout
*/
/*
wdt_disableRST();           //  Disable WDT interrupt reset MCU function.
                            //  Generally used in conjunction with ISR(WDT_vect).
wdt_enableRST();            //  Enable  WDT interrupt reset MCU function.
wdt_enable(timeout period); //  Enable the watchdog and set a timeout time
wdt_disable();              //  Disable the watchdog
wdt_reset();                //  Watchdog timer reset (feeding dog)
*/

#include "IWDT.h"

const int LEDpin = 13;
volatile int state =HIGH;


void setup() 
{
    // put your setup code here, to run once:
    pinMode( LEDpin, OUTPUT);
    pinMode(46, INPUT);        //TH244A, there is a PULLHI resistor on board.

    wdt_enableRST();       //Enable  WDT interrupt reset MCU function.
    wdt_enable(WDTO_2S);   //Enable the watchdog and set a timeout time as 2s.
    wdt_reset();           //Watchdog timer reset (feeding dog)
}

void loop() 
{
    int val;
    // put your main code here, to run repeatedly:
    state = !state;
    digitalWrite( LEDpin,  state );
    delay(1000);              // test different timeout

    val = digitalRead(46);    //When USER KEY(46) is LOW(Pressed),can not feed the dog promptly. After 2s,MCU will reset.
                          //When USER KEY(46) is HIGH(not Pressed),feed the dog promptly.After 2s,MCU will never reset.
    if(val ==  HIGH)
    {
        wdt_reset();       //Watchdog timer reset (feeding dog)
    }
}
