#ifndef _MEG32X02Z_SLEEP_H_
#define _MEG32X02Z_SLEEP_H_

#include "MG32x02z_DRV.h"
#include "MG32x02z_PW_DRV.h"
#include "MG32x02z_PW_MID.h" 
#include "MG32x02z_SYS_MID.h" 


#define sleep_bod_disable() \
do { \
    UnProtectModuleReg(PWprotect); \
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_BOD0, DISABLE); \
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_BOD1, DISABLE); \
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_BOD2, DISABLE); \
    ProtectModuleReg(PWprotect);   \
} while (0)



//extern void sleep_cpu (void);
#define sleep_cpu()                              \
do {                                             \
   UnProtectModuleReg(PWprotect); \
   MID_SuspendTick();    \
   STOP_WFI();    \
   MID_InitTick(TICK_INT_PRIORITY);    \
   ProtectModuleReg(PWprotect);   \
} while(0)


////////////////////////////////////////////////////////////////////////////////
//extern void sleep_disable (void);

#define sleep_disable()            \
do {                               \
    UnProtectModuleReg(PWprotect); \
    SCB->SCR &= (uint32_t)~((uint32_t)SCB_SCR_SLEEPDEEP_Msk);   \
    ProtectModuleReg(PWprotect);   \
} while(0)

#define  set_sleep_mode(mode)      


////////////////////////////////////////////////////////////////////////////////
//extern void sleep_enable (void);

#define sleep_enable()               \
do {                                 \
    UnProtectModuleReg(PWprotect);     \
    NVIC_EnableIRQ(SYS_IRQn);     \
    NVIC_SetPriority(SYS_IRQn,0);     \
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk; \
    __DRV_PW_ENABLE_IT(PW_IT_WK | PW_IT_IEA);  \
    __DRV_SYS_ENABLE_IT(SYS_IT_IEA);  \
    ProtectModuleReg(PWprotect);  \
} while(0)


////////////////////////////////////////////////////////////////////////////////
//extern void sleep_mode (void);

#define sleep_mode() \
do {                 \
    sleep_bod_disable() ;\
    sleep_enable();  \
    sleep_cpu();     \
    sleep_disable(); \
} while (0)



void Stop_Test();


#endif  //#ifndef _MEG32X02Z_SLEEP_H_
