

#include "MG32x02z.h"
#include "MG32x02z_USBD_API.h"

ST_USB_FUN  g_UsbFun = { 0 };



                        
USBState_TypeDef  g_UsbEP1Ctr = 
{
    .Status = USBA_Status_Idle,
    .IdleRate = 0,
    .Protocol = 1,
    
    .mHID0_ReportLength = 0,
    .mHID1_ReportLength = 0,
    .pUSB_INTERFACE0_HID_REPORT = NULL,
    .pUSB_INTERFACE1_HID_REPORT = NULL,


    .pUSB_DEVICE_DESCRIPTOR = NULL,
    .pUSB_CONFIGURATION_DESCRIPTOR = NULL,
    .pUSB_STRING_DESCRIPTOR = NULL,

    //#if MF_STRING == 1                                          
    .pManufacturer_Descriptor = NULL,
    //#endif      
    //#if PD_STRING == 1                                          
    .pProduct_Descriptor = NULL,
    //#endif   
    //#if SN_STRING == 1                                          
    .pSerialNumber_Descriptor = NULL,
    //#endif 
    //#if MG_USB_LPM_EN == 1                                      
    .pUSB_BOS_DESCRIPTOR = NULL,
    .pUSB_EXT_DESCRIPTOR = NULL,
    //#endif
};
  
void USB_SetAPIDefault(void)                     
{
    ///////////////////ʼΪĬֵҪ޸//////////////////////////////////////
    
    g_UsbFun.pfUsbInit     =  NULL;
    g_UsbFun.pfEP0ReadData =  NULL;
    g_UsbFun.pfGetStatus= NULL;
    g_UsbFun.pfClearFeature= NULL;
    g_UsbFun.pfSetFeature= NULL;
    g_UsbFun.pfGetDescriptor= NULL;
    g_UsbFun.pfSetConfiguration= NULL;
    g_UsbFun.pfSetInterface= NULL;
    g_UsbFun.pfGetInterface= NULL;
    g_UsbFun.pfControlRead= NULL;
    g_UsbFun.pfStandardRequest= NULL;
    g_UsbFun.pfClassRequest= NULL;
    g_UsbFun.pfControlWrite= NULL;
    
    g_UsbFun.pfReadEndpointData= NULL;
    g_UsbFun.pfWriteEndpointData= NULL;
    g_UsbFun.pfWriteEndpointConstData= NULL;
    g_UsbFun.pfWriteEndpointSingleData= NULL;
    
    g_UsbFun.pfStateEvent= NULL;
    g_UsbFun.pfIRQHandler= NULL;
    ///////////////////////////////////////////////////////// 
}



void USB_IRQHandler(void)
{
    if( g_UsbFun.pfIRQHandler != NULL )
    {
       (*g_UsbFun.pfIRQHandler)();
    }
}


void Usb_StateHandler(void)
{
    if( g_UsbFun.pfStateEvent != NULL )
    {
        (*g_UsbFun.pfStateEvent)();
    }
}




void API_USBD_Inital(void)
{
    if( g_UsbFun.pfUsbInit != NULL )
    {
        (*g_UsbFun.pfUsbInit)();
    }
}



void API_USBD_ReadEndpointData( USB_EP_Struct* EPX, uint8_t *bRBuffer , uint32_t bRXShift , uint32_t bRXCnt)
{
    if( g_UsbFun.pfReadEndpointData != NULL )
    {
        (*g_UsbFun.pfReadEndpointData)(EPX, bRBuffer, bRXShift, bRXCnt);
    }
}

void API_USBD_WriteEndpointData( USB_EP_Struct* EPX, uint8_t __I *btBuffer , uint32_t bTXShift , uint8_t bTXCnt )
{ 
    if( g_UsbFun.pfWriteEndpointData != NULL )
    {
        (*g_UsbFun.pfWriteEndpointData)(EPX, btBuffer, bTXShift, bTXCnt );
    }
}

void API_USBD_WriteEndpointConstData( USB_EP_Struct* EPX, uint8_t ConstData , uint32_t cTXShift , uint8_t cTXCnt )
{ 

    if( g_UsbFun.pfWriteEndpointConstData != NULL )
    {
        (*g_UsbFun.pfWriteEndpointConstData)(EPX,  ConstData,  cTXShift,  cTXCnt );
    }
}

void API_USBD_WriteEndpointSingleData( USB_EP_Struct* EPX, uint8_t sData , uint8_t shift)
{ 
    if( g_UsbFun.pfWriteEndpointSingleData != NULL )
    {
        (*g_UsbFun.pfWriteEndpointSingleData)(EPX,  sData ,  shift);
    }
}


























#if 0





#if 1

#ifndef _USB_REG_H
#define _USB_REG_H


#include "MG32x02z.h"
#include "MG32x02z__ExtraStruct.h"
#include "MG32x02z_PW_DRV.h"
#include "MG32x02z_SYS_DRV.h"
#include "MG32x02z_MEM_DRV.h"
#include "MG32x02z_USB_DRV.h"
#include "MG32x02z_USB_Init.h"

/**
 * @name	============== Data type  ==============
 *   		
 */ 
///@{

#ifdef __cplusplus
extern "C" {
#endif


/*Mouse Status*/
#define USBA_Status_Idle                0x00                       /*!< Mouse state is idle*/
#define USBA_Status_Init                0x80                       /*!< Mouse state is initializing.*/
#define USBA_Status_UpdateReport        0x40                       /*!< Mouse update data to host.*/
#define USBA_Status_BNTReportChange     0x01                       /*!< Mouse button data of report change.*/
#define USBA_Status_SensorReportChange  0x02                       /*!< Mouse sensor data of report change.*/
#define USBA_Status_WheelReportChange   0x04                       /*!< Mouse wheel data of report change.*/

#define USBA_Status_ReportChange        (USBA_Status_BNTReportChange    | \
                                         USBA_Status_SensorReportChange | \
                                         USBA_Status_WheelReportChange)           /*Mouse report data change mask*/


#define    HIBYTE( V1 )     ((uint8_t)((V1) >> 8))                           /*!<Get high byte (8 ~ 15 bit) of 16 bit data.*/
#define    LOBYTE( V1 )     ((uint8_t)((V1) & 0xFF))                         /*!<Get low byte (8 ~ 15 bit) of 16 bit data.*/

///@}

/**
 * @name	============== USB protocal Relationship ==============
 *   		
 */ 
#define FKB_TOTALFUNCTION    0x14


#define    HID_REPORT_LENGTH sizeof(HID_REPORT)

#define    EP0_PACKET_SIZE       64                                       /*!< Maximum packet size for EP0.*/
#define    EP1_PACKET_SIZE        8                                       /*!< Maximum packet size for EP1.*/
#define    EP2_PACKET_SIZE        8                                       /*!< Maximum packet size for EP2.*/

#define USB_CONFIGURATION_DESC_SIZE        9          /*!< USB Configuration descriptor data size. */
#define USB_INTERFACE_DESC_SIZE            9          /*!< USB Interface descriptor data size. */
#define USB_HID_DESC_SIZE                  9          /*!< USB HID descriptor data size. */
#define USB_ENDPOINT_DESC_SIZE             7          /*!< USB Endpoint descriptor data size. */


 
 
///@{    
//------------------------------------------------
//Standard Request Code ( bRequest)
#define    GET_STATUS          0                                              /*!< This request returns status for the specified recipient.*/
#define    CLEAR_FRATURE       1                                              /*!< This request is used to clear or disable a specific feature.*/
#define    SET_FEATURE         3                                              /*!< This request is used to set or enable a specific feature.*/
#define	   SET_ADDRESS         5                                              /*!< This request sets the device address for all future device accesses.*/
#define    GET_DESCRIPTOR      6                                              /*!< This request returns the specified descriptor if the descriptor exists.*/
#define    SET_DESCRIPTOR      7                                              /*!< This request is iptional and may be used to update existing descriptors or new descriptors may be added.*/
#define    GET_CONFIGURATION   8                                              /*!< This request returns the current device configuration value.*/
#define    SET_CONFIGURATION   9                                              /*!< This request sets the device configuration.*/
#define    GET_INTERFACE       10                                             /*!< This request returns the selected alternate setting for the specified interface.*/
#define    SET_INTERFACE       11                                             /*!< The request allows the host to select an alternate setting for the specified interface.*/
#define    SYNCH_FRAME         12                                             /*!< The request is used to set and then report an endpoint's synchronization frame.*/
//------------------------------------------------
// HID Request Codes
#define    GET_REPORT          0x01                                           /*!< The GET_REPORT request allows the host to receive a report via the Control pipe.*/
#define    GET_IDLE            0x02                                           /*!< The GET_IDLE request reads the current idle rate for a particular input report.*/
#define    GET_PROTOCOL        0x03                                           /*!< The GET_PROTOCOL request reads which protocol is currently active.*/
#define    SET_REPORT          0x09                                           /*!< The SET_REPORT request allows the host to send a report to the device, possibly setting the state of input
                                                                                   , output , or feature controls.*/
#define    SET_IDLE            0x0A                                           /*!< The SET_IDLE request silences a particular report on the Interrupt IN pipe until a new event occurs or the
                                                                                   specified amount of time passes.*/
#define    SET_PROTOCOL        0x0B                                           /*!< The SET_PROTOCOL switches between the boot protocol and the report protocol.*/

//------------------------------------------------
//Request Data transfer direction of bmRequestType
#define    GET_REQUEST         0x80                                           /*!< Device to Host.*/
#define    SET_REQUEST         0x00                                           /*!< Host to Device.*/

//------------------------------------------------
//Type of bmRequestType 
#define    REQUEST_TYPE_MASK    0x60                                          /*!< Request Type Mask.*/
#define    STANDARD_REQUEST     0x00                                          /*!< Standard Request Type.*/
#define    CLASS_REQUEST        0x20                                          /*!< Class Request Type.*/
#define    VENDOR_REQUEST       0x40                                          /*!< Vendor Request Type.*/

//------------------------------------------------
//Recipient of bmRequestType 
#define    DEVICEREQUEST        0x00                                          /*!< Device.*/
#define    INTERFACEREQUEST     0x01                                          /*!< Interface.*/
#define    ENDPOINTREQUEST      0x02                                          /*!< Endpoint.*/

//-------------------------------------------------
//Feature Selectors in Standard Feature Selectors
#define    DEVICE_REMOTE_WAKEUP 0x01                                          /*!< Device Remote wakeup.*/
#define    ENDPOINT_HALT        0x00                                          /*!< Endpoint Halt.*/

//------------------------------------------------
//Descriptor Type in Standard Request Code                                                            
#define    DEVICE_DESCRIPTOR           0x01                                   /*!<Device Descriptor.*/
#define    CONFIGURATION_DESCRIPTOR    0x02                                   /*!<Configuration Descriptor.*/
#define    STRING_DESCRIPTOR           0x03                                   /*!<String Descriptor.*/
#define    INTERFACE_DESCRIPTOR        0x04                                   /*!<Interface Descriptor.*/
#define    ENDPOINT_DESCRIPTOR         0x05                                   /*!<Endpoint Descriptor.*/
#define    DEVICE_QUALIFIER_DESCRIPTOR 0x06                                   /*!<Device Qualifier Descriptor.*/
#define    BOS_DESCRIPTOR              0x0F                                   /*!<Binary Device Object Store(BOS) Descriptor.*/
#define    DEVICE_CAPABILTY_DESCRIPTOR 0x10                                   /*!<Device Capablity Descriptor.*/

#define    CS_INTERFACE_DESCRIPTOR     0x24     

//------------------------------------------------
//Descriptor Type in Class Request Code ( HID)
#define    HID_DESCRIPTOR              0x21                                   /*!< Class Descriptor : HID.*/
#define    HID_REPORT                  0x22                                   /*!< Class Descriptor : Report.*/
#define    HID_PHYSICAL_DESCRIPTOR     0x23                                   /*!< Class Descriptor : Physical descriptor.*/

//------------------------------------------------
//Direction of bEndpointAddress in Endpoint Descriptor.
#define USB_EP_OUT                              0x00                          /*!< OUT Endpoint.*/
#define USB_EP_IN                               0x80                          /*!< IN Endpoint.*/

//------------------------------------------------
//The endpoint number of bEndpointAddress in Endpoint Descriptor.
#define USB_EP_0                                0x00                          /*!< Endpoint number is 0.*/
#define USB_EP_1                                0x01                          /*!< Endpoint number is 1.*/
#define USB_EP_2                                0x02                          /*!< Endpoint number is 2.*/
#define USB_EP_3                                0x03                          /*!< Endpoint number is 3.*/
#define USB_EP_4                                0x04                          /*!< Endpoint number is 4.*/
#define USB_EP_5                                0x05                          /*!< Endpoint number is 5.*/
#define USB_EP_6                                0x06                          /*!< Endpoint number is 6.*/
#define USB_EP_7                                0x07                          /*!< Endpoint number is 7.*/
#define USB_EP_8                                0x08                          /*!< Endpoint number is 8.*/
#define USB_EP_9                                0x09                          /*!< Endpoint number is 9.*/
#define USB_EP_10                               0x0A                          /*!< Endpoint number is 10.*/
#define USB_EP_11                               0x0B                          /*!< Endpoint number is 11.*/
#define USB_EP_12                               0x0C                          /*!< Endpoint number is 12.*/
#define USB_EP_13                               0x0D                          /*!< Endpoint number is 13.*/
#define USB_EP_14                               0x0E                          /*!< Endpoint number is 14.*/
#define USB_EP_15                               0x0F                          /*!< Endpoint number is 15.*/

//------------------------------------------------
//Transfer Type of bmAttributes in Endpoint Descriptor.
#define USB_EP_CONTROL                          0x00                          /*!< Transfer Type is Control.*/
#define USB_EP_ISOCHRONOUS                      0x01                          /*!< Transfer Type is Isochronous.*/
#define USB_EP_BULK                             0x02                          /*!< Transfer Type is Bulk.*/
#define USB_EP_INTERRUPT                        0x03                          /*!< Transfer Type is Interrupt.*/

//------------------------------------------------
//Synchronization Type of bmAttributes in Endpoint Descriptor.
#define USB_EP_NO_SYNC                          0x00                          /*!< Synchronization Type is No Synchronization Type.*/              
#define USB_EP_ASYNC                            0x04                          /*!< Synchronization Type is Asynchronous.*/
#define USB_EP_ADAPTIVE                         0x08                          /*!< Synchronization Type is Adaptive.*/
#define USB_EP_SYNC                             0x0C                          /*!< Synchronization Type is Synchronous.*/

//------------------------------------------------
//Usage Type of bmAttributes in Endpoint Descriptor.
#define USB_EP_DATA                             0x00                          /*!< Usage Type is data endpoint. */
#define USB_EP_FEEDBACK                         0x10                          /*!< Usage Type is feedback endpoint.*/
#define USB_EP_IMPLICIT                         0x20                          /*!< Usage Type is implicit feedback data endpoint.*/
///@}    
    
   
   

/**
 * @name	========= Language IDs==============
 *   		
 */ 
///@{   

#define LANGUAGEID_CHINESE_TW                   0x0404
#define LANGUAGEID_ENGLISH_US                   0x0409
#define LANGUAGEID_JAPANESE                     0x0411
#define LANGUAGEID_KOREAN                       0x0412
#define LAGNUAGEID_CHINESE_PRC                  0x0804
#define LAGNUAGEID_CHINESE_HK_SAR_PRC           0x0C04
#define LAGNUAGEID_CHINESE_SINGAPORE            0x1004

///@}
    
/**
 * @name	========= USB Software Status Control Relationship==============
 *   		
 */ 
///@{     

 /*! @struct USBCTR_TypeDef
    @brief   USB software control and Endpoint0 relationship struct.
*/ 
typedef struct __attribute__((packed))
{
        uint32_t    USBStatus;                             /*!< USB software status.*/
        uint8_t     KeyIRQFlag;                            /*!< Key interrupt flag.*/
        uint8_t     DataStage;                             /*!< Index the next transaction are DATASTAGE or STATUSSTAGE.*/
        uint8_t     RxTx[EP0_PACKET_SIZE];                 /*!< For Rx/Tx FIFO.*/
  __I   uint8_t     *Buf;                                  /*!< USB Rx Buffer Address , Maybe addressing to ROM address.*/
        uint32_t    All;                                   /*!< Transmit All size in byte.*/
        uint8_t     Tmp;					               /*!< Store some data for Next transaction( SET_ADDRESS/SET_CONFIGURATION/..).*/
        uint8_t     ConfigurationValue;                    /*!< Host set configuration value.*/
#if MG_USB_LPM_EN == 1
        uint8_t     LPM_BLE;                               /*!< LPM BLE setting from Host.*/
#endif
}USBCTR_TypeDef;                                        

//------------------------------------------------
// USBStatus Control Relationship Define.
#define    USB_STATUS_DEFAULT                           0x00000000            /*!<USB software status default value.*/
#define    USB_STATUS_EMULATION_MASK                    0x80000000            /*!<Emulation status mask of USB software status .*/
    #define    USB_STATUS_EMULATION_OK                            0x80000000  /*!<Emulation status of USB software status is success.*/
    #define    USB_STATUS_EMULATION_NO                            0x00000000  /*!<Emulation status of USB software status is not yet successful.*/
#define    USB_STATUS_RWEN_MASK                         0x40000000            /*!<Remote wakeup function mask of USB software status.*/
    #define    USB_STATUS_RWEN_ENABLE                             0x40000000  /*!<Remote wakeup enable.*/
    #define    USB_STATUS_RWEN_DISABLE                            0x00000000  /*!<Remote wakeup disable.*/
#define    USB_STATUS_BUS_MASK                          0x00FF0000            /*!<USB Bus status mask of USB software status.*/
    #define    USB_STATUS_BUS_ACT                                 0x00000000  /*!<USB Bus Active.*/
    #define    USB_STATUS_BUS_RESET                               0x00010000  /*!<USB Bus Reset.*/
    #define    USB_STATUS_BUS_SUSPEND                             0x00020000  /*!<USB Bus Suspend.*/
    #define    USB_STATUS_BUS_RESUME                              0x00040000  /*!<USB Bus Resume.*/
    #define    USB_STATUS_BUS_EXTIEVENT_WAKEUP                    0x00080000  /*!<External signal wakeup device.*/
    #define    USB_STATUS_BUS_BUSEVENT_WAKEUP                     0x00100000  /*!<Bus event wakeup devic.*/

//------------------------------------------------
// DataStage Control Relationship Define.
#define    SETUPSTAGE          0xF0
#define    DATASTAGE           0x5A
#define    DATASTAGE_SRP       0x5B
#define    DATASTAGE_GRP       0x5C
#define    DATASTAGE_STRING0   0x5D
#define    DATASTAGE_STRING1   0x5E
#define    STATUSSTAGE         0xA5
#define    SETADDRESS          0x55      
   
#define    CLASS_DATASTAGE     0xAA    


//extern USBCTR_TypeDef Ep0;    
    
    


void sAPI_USBD_Inital(void);    



void API_USBD_IRQ( void );

void API_USBD_WriteEndpointData( USB_EP_Struct* EPX, uint8_t __I *Buffer , uint32_t TXShift , uint8_t Cnt );
void API_USBD_WriteEndpointConstData( USB_EP_Struct* EPX, uint8_t ConstData , uint32_t cTXShift , uint8_t cTXCnt );
void API_USBD_WriteEndpointSingleData( USB_EP_Struct* EPX, uint8_t sData , uint8_t shift);
void API_USBD_ReadEndpointData( USB_EP_Struct* EPX, uint8_t *Buffer , uint32_t RXShift , uint32_t Cnt);

                                                            
#if MF_STRING == 1                                          
#define MFS_LEN (sizeof(MANUFACTURER_DESCRIPTOR)*2)         /*!< Manufacture descriptor size.*/
#endif                                                      

#if PD_STRING == 1
#define PDS_LEN (sizeof(PRODUCT_DESCRIPTOR)*2)              /*!< Product descriptor size.*/
#endif

#if SN_STRING == 1                                          
#define SNS_LEN (sizeof(SERIALNUMBER_DESCRIPTOR)*2)         /*!< Serial number descriptor size.*/
#endif 


    
#ifdef __cplusplus
}
#endif

    
#endif   



#endif






 /**
 ******************************************************************************
 *
 * @file        USBD_Core.c
 * @brief       The USBD core Code's c file.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.05
 * @date        2022/08/19
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32x02z.h"
#include "MG32x02z_USBD_API.h"


//#include "MG32x02z_USBD_MouseDescriptor.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define USB_EP_REG_SHIFT       0
#define USB_EP_IT_SHIFT        8



/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static const uint8_t  EPn_ID_Table[8]          = {                    0 , MG_USB_EP1_ADDRESS    , MG_USB_EP2_ADDRESS    , MG_USB_EP3_ADDRESS    , MG_USB_EP4_ADDRESS    , MG_USB_EP5_ADDRESS    , MG_USB_EP6_ADDRESS    , MG_USB_EP7_ADDRESS    };
static const uint16_t EPn_RXSIZE_TABLE[8]      = {MG_USB_EP0_SRAM_RXSIZE, MG_USB_EP1_SRAM_RXSIZE, MG_USB_EP2_SRAM_RXSIZE, MG_USB_EP3_SRAM_RXSIZE, MG_USB_EP4_SRAM_RXSIZE, MG_USB_EP5_SRAM_RXSIZE, MG_USB_EP6_SRAM_RXSIZE, MG_USB_EP7_SRAM_RXSIZE};
static const uint16_t EPn_RXSRAM_TABLE[8]      = {USB_EP0_SRAM_RXADR    , USB_EP1_SRAM_RXADR    , USB_EP2_SRAM_RXADR    , USB_EP3_SRAM_RXADR    , USB_EP4_SRAM_RXADR    , USB_EP5_SRAM_RXADR    , USB_EP6_SRAM_RXADR    , USB_EP7_SRAM_RXADR}   ;
static const uint16_t EPn_TXSRAM_TABLE[8]      = {USB_EP0_SRAM_TXADR    , USB_EP1_SRAM_TXADR    , USB_EP2_SRAM_TXADR    , USB_EP3_SRAM_TXADR    , USB_EP4_SRAM_TXADR    , USB_EP5_SRAM_TXADR    , USB_EP6_SRAM_TXADR    , USB_EP7_SRAM_TXADR}   ;
static const uint8_t  EPn_InitaStatus_TABLE[8] = {MG_USB_EP0_STATUS     , MG_USB_EP1_STATUS     , MG_USB_EP2_STATUS     , MG_USB_EP3_STATUS     , MG_USB_EP4_STATUS     , MG_USB_EP5_STATUS     , MG_USB_EP6_STATUS     , MG_USB_EP7_STATUS     };

static uint32_t USB_EP_TABLE[16] = {USB_EP0_Base , USB_EP1_Base , USB_EP2_Base , USB_EP3_Base , USB_EP4_Base , USB_EP5_Base , USB_EP6_Base , USB_EP7_Base,
                                     USB_IT_EP0   , USB_IT_EP1   , USB_IT_EP2   , USB_IT_EP3   , USB_IT_EP4   , USB_IT_EP5   , USB_IT_EP6   , USB_IT_EP7  };

static USBCTR_TypeDef Ep0;


/* Private function prototypes -----------------------------------------------*/ 



void sAPI_USBD_Endpoint0_ReadData( void );                                      
void sAPI_USBD_Get_Status( void );                                      
void sAPI_USBD_ClearFeature( void );
void sAPI_USBD_SetFeature( void );
void sAPI_USBD_GetDescriptor( void );
void sAPI_USBD_SetConfiguration( void );
void sAPI_USBD_SetInterface( void );
void sAPI_USBD_GetInterface( void );
void sAPI_USBD_ControlRead( void );
void sAPI_USBD_StandardRequest( void );  
void sAPI_USBD_ClassRequest( void );
void sAPI_USBD_ControlWrite( void );
void sAPI_USB_IRQHandler(void);
void sAPI_USBD_Inital(void);
void sAPI_USBD_StateHandler(void);
ST_USB_FUN  g_UsbFun = 
{
    .pfUsbInit    = sAPI_USBD_Inital,
    .pfEP0ReadData=sAPI_USBD_Endpoint0_ReadData,

    .pfGetStatus=sAPI_USBD_Get_Status,
    .pfClearFeature=sAPI_USBD_ClearFeature,
    .pfSetFeature=sAPI_USBD_SetFeature,
    .pfGetDescriptor=sAPI_USBD_GetDescriptor,
    .pfSetConfiguration=sAPI_USBD_SetConfiguration,
    .pfSetInterface=sAPI_USBD_SetInterface,
    .pfGetInterface=sAPI_USBD_GetInterface,
    .pfControlRead=sAPI_USBD_ControlRead,
    .pfStandardRequest=sAPI_USBD_StandardRequest,
    .pfClassRequest=sAPI_USBD_ClassRequest,
    .pfControlWrite=sAPI_USBD_ControlWrite,
    
    .pfStateEvent=sAPI_USBD_StateHandler,
    
    .pfIRQHandler=sAPI_USB_IRQHandler
};

                                      
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

                        
USBState_TypeDef  g_UsbEP1Ctr = 
{
    .Status = USBA_Status_Idle,
    .IdleRate = 0,
    .Protocol = 1,
    
    .mHID0_ReportLength = 0,
    .mHID1_ReportLength = 0,
    .pUSB_INTERFACE0_HID_REPORT = NULL,
    .pUSB_INTERFACE1_HID_REPORT = NULL,


    .pUSB_DEVICE_DESCRIPTOR = NULL,
    .pUSB_CONFIGURATION_DESCRIPTOR = NULL,
    .pUSB_STRING_DESCRIPTOR = NULL,

    #if MF_STRING == 1                                          
    .pManufacturer_Descriptor = NULL,
    #endif      
    #if PD_STRING == 1                                          
    .pProduct_Descriptor = NULL,
    #endif   
    #if SN_STRING == 1                                          
    .pSerialNumber_Descriptor = NULL,
    #endif 
    #if MG_USB_LPM_EN == 1                                      
    .pUSB_BOS_DESCRIPTOR = NULL,
    .pUSB_EXT_DESCRIPTOR = NULL,
    #endif
};
  
void USB_SetAPIDefault(void)                     
{
    ///////////////////ʼΪĬֵҪ޸//////////////////////////////////////
    
    g_UsbFun.pfUsbInit    = sAPI_USBD_Inital;
    g_UsbFun.pfEP0ReadData=sAPI_USBD_Endpoint0_ReadData;
    g_UsbFun.pfGetStatus=sAPI_USBD_Get_Status;
    g_UsbFun.pfClearFeature=sAPI_USBD_ClearFeature;
    g_UsbFun.pfSetFeature=sAPI_USBD_SetFeature;
    g_UsbFun.pfGetDescriptor=sAPI_USBD_GetDescriptor;
    g_UsbFun.pfSetConfiguration=sAPI_USBD_SetConfiguration;
    g_UsbFun.pfSetInterface=sAPI_USBD_SetInterface;
    g_UsbFun.pfGetInterface=sAPI_USBD_GetInterface;
    g_UsbFun.pfControlRead=sAPI_USBD_ControlRead;
    g_UsbFun.pfStandardRequest=sAPI_USBD_StandardRequest;
    g_UsbFun.pfClassRequest=sAPI_USBD_ClassRequest;
    g_UsbFun.pfControlWrite=sAPI_USBD_ControlWrite;
    
    g_UsbFun.pfStateEvent=sAPI_USBD_StateHandler;
    g_UsbFun.pfIRQHandler=sAPI_USB_IRQHandler;
    ///////////////////////////////////////////////////////// 
}
/**
 *******************************************************************************
 * @brief	   USB IRQ handler
 * @details     
 * @exception  No
 * @note                     
 *******************************************************************************
 */
extern void API_USBSerial_IRQ(void);
void USB_IRQHandler(void)
{

    if( g_UsbFun.pfIRQHandler != NULL )
    {
       (*g_UsbFun.pfIRQHandler)();
    }

//    API_USBSerial_IRQ();   
}
/**
 *******************************************************************************
 * @brief	    USB function inital.
 * @details         
 * @exception   No
 * @note                    
 *******************************************************************************
 */  
void sAPI_USBD_Inital(void)
{
    USB_EP_Struct*  USB_EPX;
    uint8_t         USB_InitTmp;

    

    USB_Cmd(ENABLE);
    
    NVIC_DisableIRQ(USB_IRQn);
    USB_ITEA_Cmd(DISABLE);
 

    g_UsbEP1Ctr.Status = USBA_Status_Idle;
    g_UsbEP1Ctr.IdleRate = 0;
    g_UsbEP1Ctr.Protocol = 1;
 
    //=====================================================
    //EP0 config
    
    USB_TriggerEndpointRst(USB_EP0 , EP_RST_TX_RX);
    
    USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);  
    USB_EndpintIT_Config( USB_EP0 , (USB_EP_IE_TXDONE | USB_EP_IE_RXDONE) , ENABLE);
    

    USB_SetEndpointRXDataAddress(USB_EP0, EPn_RXSRAM_TABLE[0]);             
    USB_SetEndpointTXDataAddress(USB_EP0, EPn_TXSRAM_TABLE[0]);                
    
    USB_SetEndpointRXBlock(USB_EP0,64);
    
    //====================================================
    //EP1 ~ EP7 config
    for(USB_InitTmp=1;USB_InitTmp<8;USB_InitTmp++)
    {
        USB_EPX = ((USB_EP_Struct*)USB_EP_TABLE[ USB_EP_REG_SHIFT + USB_InitTmp]);

        //-----------------------------------------------------------------
        //Defeault Inital 
        USB_TriggerEndpointRst(USB_EPX , EP_RST_TX_RX);
        USB_SetEndpointStatus(USB_EPX, EP_RX_DISABLE_TX_DISABLE);
        USB_EndpintIT_Config( USB_EPX , USB_EP_IE_ALL, DISABLE); 

        //-----------------------------------------------------------------
        //Set buffer relationship control.
        USB_SetEndpointRXDataAddress(USB_EPX, EPn_RXSRAM_TABLE[USB_InitTmp]);              /*!<Set SRAM address that USB_EPX_RX start save address. */
        USB_SetEndpointTXDataAddress(USB_EPX, EPn_TXSRAM_TABLE[USB_InitTmp]);              /*!<Set SRAM address that USB_EPX_TX start send address..*/

        if(EPn_RXSIZE_TABLE[USB_InitTmp] != 0)        
        {
            USB_SetEndpointRXBlock(USB_EPX,EPn_RXSIZE_TABLE[USB_InitTmp]);  
        }
        
        if(EPn_InitaStatus_TABLE[USB_InitTmp] & MG_USB_DBUF_MSK)
        {
            USB_EndpointDoubleBufferMode_Cmd(USB_EPX,ENABLE);
        }
        else
        {
            USB_EndpointDoubleBufferMode_Cmd(USB_EPX,DISABLE);
        }
        //-----------------------------------------------------------------
        //Set Endpoint Address
        USB_SetEndpointAddress(USB_EPX, EPn_ID_Table[USB_InitTmp] ); 
        
        //-----------------------------------------------------------------
        //Set Endpoint Mode.
        switch(( EPn_InitaStatus_TABLE[USB_InitTmp] & MG_USB_MODE_MASK))
        {
            case MG_USB_MODE_RX_ISO_TX_BKINT:
               USB_EndpointMode_Select(USB_EPX , EP_RX_ISO_TX_BKINT);
               break;
            case MG_USB_MODE_RX_BKINT_TX_ISO:
               USB_EndpointMode_Select(USB_EPX , EP_RX_BKINT_TX_ISO);
               break;
            case MG_USB_MODE_RX_TX_ISO:
               USB_EndpointMode_Select(USB_EPX , EP_RX_ISO_TX_ISO);
               break;
            case MG_USB_MODE_RX_TX_BKINT:
            default:
               USB_EndpointMode_Select(USB_EPX , EP_RX_BKINT_TX_BKINT);
               break;
        }
    }
    //===================================================
    //USB LPM Receive Disable
    USB_LPMhandshakeMode_Select(USB_LPM_DISABLE);
    //===================================================
    //USB Interrupt Config
    #if MG_USB_LPM_EN == 1
        USB_IT_Config(( USB_IT_EP0 | USB_IT_BUS | USB_IT_BUS_SUSF | USB_IT_BUS_RSTF | USB_IT_BUS_RSMF | USB_IT_LPM) , ENABLE);
    #else
        USB_IT_Config(( USB_IT_EP0 | USB_IT_BUS | USB_IT_BUS_SUSF | USB_IT_BUS_RSTF | USB_IT_BUS_RSMF) , ENABLE);      
    #endif
    USB_ITEA_Cmd(ENABLE);
    NVIC_EnableIRQ(USB_IRQn);
    
    //====================================================
    //USB module event wakeup from STOP mode enable.
    UnProtectModuleReg(PWprotect);
    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_USB,ENABLE);
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_USB,ENABLE);
    ProtectModuleReg(PWprotect);

    //====================================================
    //Control Parameter inital.
    Ep0.USBStatus          = USB_STATUS_DEFAULT;
    Ep0.ConfigurationValue = 0;
    //=====================================================
    //USB Connect to Bus (Enable DP pull-up R
    USB_Connect_Cmd(ENABLE);
 
}
/**
 *******************************************************************************
 * @brief	    Read data from RX SRAM of the endpoint.
 * @details     
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   bRBuffer : The pointer is save data  buffer.
 * @param[in]   bRXShift : Starting receive data byte from RX SRAM of the endpoint.
 * @param[in]   bRXCnt   : Total receive data size.
 * @return      
 * @exception   No
 * @note        RX SRAM address of the endpoint have to set.
 *******************************************************************************
 */ 
void API_USBD_ReadEndpointData( USB_EP_Struct* EPX, uint8_t *bRBuffer , uint32_t bRXShift , uint32_t bRXCnt)
{
    uint8_t  USB_REP_Tmp;
    uint8_t *USB_EP_RAM;
    
    USB_EP_RAM = (uint8_t*)((0x30000000 + EPX->RX.H[0] + bRXShift));
    
    for( USB_REP_Tmp = 0; USB_REP_Tmp <bRXCnt ; USB_REP_Tmp ++)
    {
        bRBuffer[USB_REP_Tmp] =  USB_EP_RAM[USB_REP_Tmp];
    }
}
/**
 *******************************************************************************
 * @brief	    Write data to TX SRAM of the endpoint.
 * @details     
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   btBuffer : The pointer is data source.
 * @param[in]   bTXShift : Write address is that shift address from the TX start SRAM address.
 * @param[in]   bTXCnt   : Write total data size.
 * @return      
 * @exception   No
 * @note        TX SRAM address of the endpoint have to set.              
 *******************************************************************************
 */ 
void API_USBD_WriteEndpointData( USB_EP_Struct* EPX, uint8_t __I *btBuffer , uint32_t bTXShift , uint8_t bTXCnt )
{ 
    uint8_t bEPTX_Tmp;
    uint8_t *USB_EP_RAM;
  
    USB_EP_RAM = (uint8_t*)(0x30000000 + EPX->TX.H[0] + bTXShift);
    
    
    for ( bEPTX_Tmp=0 ; bEPTX_Tmp<bTXCnt ; bEPTX_Tmp++ ) 
    {
        USB_EP_RAM[bEPTX_Tmp] = btBuffer[bEPTX_Tmp];
    }
}
/**
 *******************************************************************************
 * @brief	    Write a constant value to TX SRAM of the endpoint.
 * @details 
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   ConstData: Constant value.
 * @param[in]   cTXShift : Write address is that shift address from the TX start SRAM address.
 * @param[in]   cTXCnt   : Write total data size.
 * @return      
 * @exception   No
 * @note        TX SRAM address of the endpoint have to set.              
 *******************************************************************************
 */ 
void API_USBD_WriteEndpointConstData( USB_EP_Struct* EPX, uint8_t ConstData , uint32_t cTXShift , uint8_t cTXCnt )
{ 
    uint8_t cEPTX_Tmp;
    uint8_t *USB_EP_RAM;
  
    USB_EP_RAM = (uint8_t*)(0x30000000 + EPX->TX.H[0] + cTXShift);
    
    for ( cEPTX_Tmp=0 ; cEPTX_Tmp < cTXCnt ; cEPTX_Tmp++ ) 
    {
        USB_EP_RAM[cEPTX_Tmp] = ConstData;
    }
}    
/**
 *******************************************************************************
 * @brief	   Write a byte to TX SRAM of the endpoint. 
 * @details     
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   sData    : Write data.
 * @param[in]   shift    : Write address is that shift address from the TX start SRAM address.
 * @return      
 * @exception   No
 * @note        TX SRAM address of the endpoint have to set.               
 *******************************************************************************
 */ 
void API_USBD_WriteEndpointSingleData( USB_EP_Struct* EPX, uint8_t sData , uint8_t shift)
{
    uint8_t *USB_EP_RAM;
    
    USB_EP_RAM = (uint8_t*)(0x30000000 + EPX->TX.H[0]);
    
    USB_EP_RAM[shift] = sData;
}
/**
 *******************************************************************************
 * @brief	   EP0 receiving data.
 * @details     
 * @return      
 * @exception  No 
 * @note            
 *******************************************************************************
 */ 
void sAPI_USBD_Endpoint0_ReadData( void )
{ 
    uint16_t BLen, tmp;
    
    //==============================================================================
    //Recing SETUP token.
    tmp = __DRV_USB_GETSETUP_STATUS();
    if ( tmp & ( USB_EP0_STOVW | USB_EP0_EDOVW ))                  // Setup Token
    { 
        Ep0.DataStage = SETUPSTAGE;
        while(1)
        { 
            tmp = __DRV_USB_GETSETUP_STATUS();
            
            do{ 
                tmp = __DRV_USB_GETSETUP_STATUS();
            }while(tmp & USB_EP0_STOVW);                           // waiting STOVE = 0

            do{                                        
                tmp = __DRV_USB_GETSETUP_STATUS();         
            }while(!( tmp & USB_EP0_EDOVW ));                      // waiting EDOVW = 1                                        


            __DRV_USB_CLEAR_EDOVW();
            USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_RXDONE);

            BLen = USB_GetEndpointRXSize(USB_EP0);
                                         
            API_USBD_ReadEndpointData(USB_EP0 , Ep0.RxTx , 0 , BLen);

            tmp = __DRV_USB_GETSETUP_STATUS();
            if (!(tmp & ( USB_EP0_STOVW | USB_EP0_EDOVW )))
                break;
        }

        USB_SetEndpointStatus(USB_EP0, EP_RX_VALID_TX_NAK);
        __DRV_USB_CLEAR_RXSETUP();

        Ep0.All = BLen;                                             
        
    }
    //=============================================================================
    //Receing data.
    else                                                                                      
    {
        BLen    = USB_GetEndpointRXSize(USB_EP0);
        Ep0.All = Ep0.All - BLen;
        
        API_USBD_ReadEndpointData( USB_EP0, Ep0.RxTx , 0 , BLen);
        USB_SetEndpointStatus(USB_EP0, EP_RX_VALID);
        
        Ep0.DataStage = STATUSSTAGE;
        USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
    }                              
}
/**
 *******************************************************************************
 * @brief	   This request returns status for the specified recipient. 
 * @details     
 * @return      
 * @exception  No
 * @note                 
 *******************************************************************************
 */ 
void sAPI_USBD_Get_Status( void )
{ 
    uint8_t   tmp;
    uint16_t  USB_Status;
     
    Ep0.All = 2;                                                                                                          // Only 2 byte transfer to the host
                                                                                                                          
    Ep0.RxTx[1] = 0;                                                                                                      
    switch( Ep0.RxTx[0] & 0x03 )                                                                                          // Request Type ( Reserve low 2 bit )
    {                                                                                                                     
        case DEVICEREQUEST:                                                                                               
                              if ( (Ep0.USBStatus & USB_STATUS_RWEN_MASK) == USB_STATUS_RWEN_ENABLE )                     // Check Remote wakeup enabled or not
                              {                                                                                           
                                   Ep0.RxTx[0] = 0x02;                                                                    // Return Function Remove Wake-up Enable
                              }                                                                                           
                              else                                                                                        
                              {                                                                                           
                                   Ep0.RxTx[0] = 0x00;                                                                    // Return Function Remove Wake-up Disable                                                     
                              }
                              break;                                                                     
        case ENDPOINTREQUEST:  
                              tmp = (Ep0.RxTx[4] & 0x0F);

                              switch(tmp)
                              {
                                  case 1:
                                          USB_Status = USB_GetEndpointStatus(USB_EP1);
                                          break;
                                  default:
                                          USB_Status = 0;
                                          break;
                              }
                              if((USB_Status & USB_EP0CR1_TXSTL0_mask_h1) || (USB_Status & USB_EP0CR1_RXSTL0_mask_h1))
                              {
                                  Ep0.RxTx[0] = 0x01;                                                                     // if EndPoint Rx/Tx STAL then set EndPoint Halt
                              }
                              else
                              {
                                  Ep0.RxTx[0] = 0x00;                                                                     // else seting this EndPoint Avaliable for Rx/Tx 
                              }
                              
                              break;
        case INTERFACEREQUEST: 
        default:              
                              USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                              break; 
    }
} 


/**
 *******************************************************************************
 * @brief	    Clear Feature.
 * @details     This request is used to clear or disable a specific feature.
 * @return      
 * @exception   No
 * @note                   
 *******************************************************************************
 */ 
void sAPI_USBD_ClearFeature( void )
{ 
    switch( Ep0.RxTx[0] & 0x03 )                                                                     // Request Type ( Reserve low 2 bit )
    { 
        case DEVICEREQUEST:    if ( Ep0.RxTx[2] == DEVICE_REMOTE_WAKEUP )
                               {
                                   Ep0.USBStatus &= (uint32_t)(~USB_STATUS_RWEN_MASK);               // Disable the Device Remote Wakeup function
                               }
                               else
                               {   
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;                                                       
        case ENDPOINTREQUEST:                                                                        // Disable Endpoint Halt.
                               if ( Ep0.RxTx[2] == ENDPOINT_HALT )
                               { 
                                   switch((Ep0.RxTx[4] & 0x0F))
                                   {
                                       case 1:
                                               USB_TriggerEndpointRst(USB_EP1,EP_RST_TX_RX);
                                               USB_SetEndpointINSequenceBit(USB_EP1,0);
                                               USB_SetEndpointOUTSequenceBit(USB_EP1,0);
                                               USB_SetEndpointStatus(USB_EP1, EP_RX_DISABLE_TX_NAK);
                                               break;
                                       default:
                                               break;
                                   }
                               }
                               else
                               { 
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;
        case INTERFACEREQUEST: 
        default:               
                               USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               break;
    }
}
/**
 *******************************************************************************
 * @brief	    Set feature.
 * @details     This request is used to set or enable a specific feature
 * @return      
 * @exception   No
 * @note                     
 *******************************************************************************
 */
void sAPI_USBD_SetFeature( void )
{ 

    switch( Ep0.RxTx[0] & 0x03 )                                                                      // Request Type ( Reserve low 2 bit )
    { 
        case DEVICEREQUEST:    
                               if ( Ep0.RxTx[2] == DEVICE_REMOTE_WAKEUP )
                               {
                                   Ep0.USBStatus |= USB_STATUS_RWEN_MASK;                             // Endpoint the Device Remote Wakeup function
                               }
                               else
                               { 
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;                                                                 // Enable Endpoint Halt.
        case ENDPOINTREQUEST:                                                 
                               if ( Ep0.RxTx[2] == ENDPOINT_HALT )
                               { 
                                   switch((Ep0.RxTx[4] & 0x0F))
                                   {
                                       case 1:
                                               USB_SetEndpointStatus(USB_EP1, EP_RX_STALL_TX_STALL);
                                               break;
                                       default:
                                               break;
                                   }
                               }
                               else
                               { 
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;
        case INTERFACEREQUEST: 
        default:               
                               USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL); 
                               break; 
    }
}  

/**
 *******************************************************************************
 * @brief	   Get Descriptor. 
 * @details    This request returns the specified descriptor if the descriptor exists.
 * @return      
 * @exception  No
 * @note                     
 *******************************************************************************
 */
void sAPI_USBD_GetDescriptor( void )
{ 
    ctype WLen;
  
    WLen.W  = 0;                                  
    Ep0.All = (uint32_t)((Ep0.RxTx[7] << 8) + Ep0.RxTx[6]);

    //=======================================================================================
    //Descriptor Type : High byte of the wValue field.
    switch( Ep0.RxTx[3] )	
    { 
        //------------------------------------------------------------------------------------------------
        //Device Descriptor :
        case DEVICE_DESCRIPTOR:       
                                      Ep0.Buf   = g_UsbEP1Ctr.pUSB_DEVICE_DESCRIPTOR;
                                      WLen.B[0] = Ep0.Buf[0];
                                      break;
        //------------------------------------------------------------------------------------------------
        //Configuration Descriptor :
        case CONFIGURATION_DESCRIPTOR: 
                                      //------------------------------------------------------------------
                                      //*. Descriptor Index : Low byte of the wValue field.
                                      //*. The sample only one configuration.
                                      Ep0.Buf   = g_UsbEP1Ctr.pUSB_CONFIGURATION_DESCRIPTOR;
                                      WLen.B[1] = Ep0.Buf[3];
                                      WLen.B[0] = Ep0.Buf[2];
                                      break;
        //------------------------------------------------------------------------------------------------
        //String Descriptor :
        case STRING_DESCRIPTOR:        
                                      //------------------------------------------------------------------
                                      //*. Descriptor Index : Low byte of the wValue field.
                                      WLen.B[0] = 0;
                                      switch( Ep0.RxTx[2] )
                                      { 
                                          case 0:  
                                                   Ep0.Buf   = g_UsbEP1Ctr.pUSB_STRING_DESCRIPTOR;
                                                   WLen.B[0] = Ep0.Buf[0]; 
                                                   break;
                                          //-------------------------------------------------------------
                                          //* Index define refer to device descriptor.
                                          //    1.iManufacture Index  = 0x01
                                          //    2.iProduct Index      = 0x02
                                          //    3.iSerialNumber Index = 0x03 
                                          case 1:  
                                                   #if MF_STRING_INDEX == 1
                                                       if ( g_UsbEP1Ctr.pUSB_DEVICE_DESCRIPTOR[14] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf = g_UsbEP1Ctr.pManufacturer_Descriptor;
                                                           WLen.B[0] = MFS_LEN;
                                                           break;
                                                       }
                                                   #elif PD_STRING_INDEX == 1
                                                       if ( g_UsbEP1Ctr.pUSB_DEVICE_DESCRIPTOR[15] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = g_UsbEP1Ctr.pProduct_Descriptor;
                                                           WLen.B[0]     = PDS_LEN;
                                                           break;
                                                       }
                                                   #elif SN_STRING_INDEX == 1
                                                       if ( g_UsbEP1Ctr.pUSB_DEVICE_DESCRIPTOR[16] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = g_UsbEP1Ctr.pSerialNumber_Descriptor;
                                                           WLen.B[0]     = SNS_LEN;
                                                           break;
                                                       }
                                                   #endif
                                                   
                                                    
                                                   Ep0.DataStage = STATUSSTAGE;       
                                                   
                                                   break;
                                          case 2:  
                                                   #if PD_STRING_INDEX == 2
                                                       if ( g_UsbEP1Ctr.pUSB_DEVICE_DESCRIPTOR[15] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = g_UsbEP1Ctr.pProduct_Descriptor;
                                                           WLen.B[0]     = PDS_LEN;
                                                           break;
                                                       }
                                                   #elif SN_STRING_INDEX == 2
                                                       if ( g_UsbEP1Ctr.pUSB_DEVICE_DESCRIPTOR[16] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = g_UsbEP1Ctr.pSerialNumber_Descriptor;
                                                           WLen.B[0]     = SNS_LEN;
                                                           break;
                                                       }
                                                   #endif
                                                   
                                                    
                                                   Ep0.DataStage = STATUSSTAGE;       
                                                   
                                                   break;
                                          case 3:  
                                                   #if SN_STRING_INDEX == 3
                                                       if ( g_UsbEP1Ctr.pUSB_DEVICE_DESCRIPTOR[16] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = g_UsbEP1Ctr.pSerialNumber_Descriptor;
                                                           WLen.B[0]     = SNS_LEN;
                                                           break;
                                                       }
                                                   #endif
                                                   
                                                   Ep0.DataStage = STATUSSTAGE;       
                                                   
                                                   break;
                                          default: 
                                                   Ep0.DataStage = STATUSSTAGE;
                                                   break;
                                    }
                                    Ep0.Tmp = WLen.B[0];
                                    break;
        //------------------------------------------------------------------------------------------------
        //HID Descriptor.
        case HID_DESCRIPTOR:           
                                    switch( Ep0.RxTx[4])
                                    {
                                        case 0:             
                                                Ep0.Buf = &g_UsbEP1Ctr.pUSB_CONFIGURATION_DESCRIPTOR[USB_CONFIGURATION_DESC_SIZE +  USB_INTERFACE_DESC_SIZE] ;
                                                break;
                                        default:
                                                Ep0.DataStage = STATUSSTAGE;
                                                break;                                            
                                    }
                                    WLen.B[0] = Ep0.Buf[0];
                                    break;
        //-------------------------------------------------------------------------------------------------
        //HID Report.
        case HID_REPORT:                   
                                    switch( Ep0.RxTx[4])    
                                    {
                                        case 0:
                                                Ep0.Buf   = g_UsbEP1Ctr.pUSB_INTERFACE0_HID_REPORT;
                                                WLen.B[0] = LOBYTE(g_UsbEP1Ctr.mHID0_ReportLength);
      	                                        WLen.B[1] = HIBYTE(g_UsbEP1Ctr.mHID0_ReportLength);
                                                break;
                                        default:
                                                Ep0.DataStage = STATUSSTAGE;
                                                break;
                                    }
    	                            
    	                            break;
        //-------------------------------------------------------------------------------------------------
        //BOS Descriptor.
        #if MG_USB_LPM_EN == 1
        case BOS_DESCRIPTOR:
                                    Ep0.Buf = (uint8_t*) g_UsbEP1Ctr.pUSB_BOS_DESCRIPTOR;   //&USB_BOS_DESCRIPTOR;
                                    WLen.B[0] = Ep0.Buf[2];
                                    break;
        #endif
    	default:                      
                                    Ep0.DataStage = STATUSSTAGE;
                                    break;
    }
    if ( Ep0.All > WLen.W )
    {
        Ep0.All = WLen.W;
    }
}
/**
 *******************************************************************************
 * @brief	   Set Configuration 
 * @details    This request sets the device configuration.
 * @return      
 * @exception  No 
 * @note       The sample code only support one configuration.          
 *******************************************************************************
 */                              
void sAPI_USBD_SetConfiguration( void )
{ 
    USB_EP_Struct*  USB_EPX;
    uint8_t         USBConfig_Tmp;
    
    Ep0.ConfigurationValue =  Ep0.RxTx[2];
    
    if( Ep0.ConfigurationValue  == 1)
    { 
        for( USBConfig_Tmp = 1; USBConfig_Tmp < 8; USBConfig_Tmp ++)
        {
            USB_EPX = ((USB_EP_Struct*)USB_EP_TABLE[ USB_EP_REG_SHIFT + USBConfig_Tmp]);
            USB_IT_Config( USB_EP_TABLE[ USB_EP_IT_SHIFT + USBConfig_Tmp] ,ENABLE);

            switch( (EPn_InitaStatus_TABLE[USBConfig_Tmp] & MG_USBEP_OPEN_MASK) )
            {
                case MG_USBEP_RX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_RXDONE) , ENABLE); 
                                         USB_SetEndpointStatus(USB_EPX , EP_RX_VALID); 
                                         break;
                case MG_USBEP_TX_OPEN: 
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_TXDONE) , ENABLE); 
                                         USB_SetEndpointStatus(USB_EPX , EP_TX_NAK);
                                         break;
                case MG_USBEP_RX_TX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_TXDONE | USB_EP_IE_RXDONE) , ENABLE); 
                                         USB_SetEndpointStatus(USB_EPX , EP_RX_VALID_TX_NAK);
                                         break;
                case MG_USBEP_DB_RX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_DBUFFER_RXDONE) , ENABLE); 
                                         USB_SetDoubleBufferEndpointStatus(USB_EPX , EP_DB_RXBUFALL_VALID);
                                         break;
                case MG_USBEP_DB_TX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_DBUFFER_TXDONE) , ENABLE); 
                                         USB_SetDoubleBufferEndpointStatus(USB_EPX,EP_DB_TXBUFALL_NAK);
                                         break;
                default:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_TXDONE | USB_EP_IE_RXDONE) , DISABLE); 
                                         USB_IT_Config( USB_EP_TABLE[ USB_EP_IT_SHIFT + USBConfig_Tmp] ,DISABLE);
                                         USB_SetEndpointStatus(USB_EPX , EP_RX_DISABLE_TX_DISABLE);
                                         break;     
            }
        }
        //======================================================
        //LPM Control.
        #if MG_USB_LPM_EN == 1
            USB_LPMhandshakeMode_Select(USB_LPM_ACK);
        #endif
        //======================================================
        //USB enumeration PASS
        Ep0.USBStatus |= USB_STATUS_EMULATION_OK;                             // Emulation Flow pass

    }
    else
    {
        USB_SetEndpointStatus(USB_EP1 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP2 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP3 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP4 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP5 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP6 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP7 , EP_RX_DISABLE_TX_DISABLE);
        
        
    }
    USB_SetEndpointTXSize(USB_EP0, 0);
    USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                              // USB will return ACK immediately when receive IN transaction
}


/**
 *******************************************************************************
 * @brief	    Set Interface.
 * @details     
 * @return      
 * @exception   No
 * @note                      
 *******************************************************************************
 */
void sAPI_USBD_SetInterface( void )
{ 
    switch( Ep0.RxTx[4] )
    { 
        case 0:         
                 if ( Ep0.RxTx[2] > 0 )                                          
                 {
                     USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);        
                 }
                 else
                 { 
                     USB_SetEndpointTXSize(USB_EP0, 0);
                     USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);
                 }
                 break;
        default: 
                 USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);            
                 break;
    }
}

/**
 *******************************************************************************
 * @brief	    Get Interface.
 * @details     
 * @return      
 * @exception   No
 * @note                    
 *******************************************************************************
 */
void sAPI_USBD_GetInterface( void )
{ 
    Ep0.All = 1;
    switch( Ep0.RxTx[4] )
    { 
        case 0:         
                 Ep0.RxTx[0] = 0;                                                 // For Interface1 ( HID )
                 break;
        default: 
                 USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);            // Set Rx/Tx STAL 
                 break;
    }
}

/**
 *******************************************************************************
 * @brief	   Control USB EP0 Transmit (Host EP0 IN).
 * @details     
 * @return      
 * @exception  No 
 * @note                     
 *******************************************************************************
 */
void sAPI_USBD_ControlRead( void )                                           // Host In , USB Out ( Only for EP0 )
{ 
    uint8_t USB_CtrlRdBLen;
    
    if ( Ep0.DataStage == DATASTAGE )                                             // In DATASTAGE we should move Data to TXFIFO
    { 
        if ( Ep0.All > MG_USB_EP0_DSIZE )
        {
            USB_CtrlRdBLen = MG_USB_EP0_DSIZE;
        }
        else
        {
            USB_CtrlRdBLen = (uint8_t)Ep0.All;
    	}
        API_USBD_WriteEndpointData( USB_EP0 , Ep0.Buf , 0 , USB_CtrlRdBLen );

        USB_SetEndpointTXSize(USB_EP0, USB_CtrlRdBLen);
        USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                               // USB will return ACK immediately when receive IN transaction
        Ep0.All -= USB_CtrlRdBLen;                                                 // Calculated the Remain Data size
        Ep0.Buf += USB_CtrlRdBLen;                                                 // Move Buffer Address in Right position
    }
    else if(Ep0.DataStage == DATASTAGE_GRP)
    {
        if ( Ep0.All > MG_USB_EP0_DSIZE )
        {
            USB_CtrlRdBLen = MG_USB_EP0_DSIZE;
        }
        else
        {
            USB_CtrlRdBLen = (uint8_t)Ep0.All;
        }
      	API_USBD_WriteEndpointData( USB_EP0 , Ep0.Buf , 0 , USB_CtrlRdBLen );
        
        USB_SetEndpointTXSize(USB_EP0,USB_CtrlRdBLen);                              // Set this byte will Trigger USB to Transmit Data to the Host   
        USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                                // USB will return ACK immediately when receive IN transaction        
        Ep0.All -= USB_CtrlRdBLen;                                                  // Calculated the Remain Data size
        Ep0.Buf += USB_CtrlRdBLen;                                                  // Move Buffer Address in Right position
        
    }
    else if(Ep0.DataStage == DATASTAGE_STRING0)
    {
        Ep0.DataStage  = DATASTAGE_STRING1;
        
        API_USBD_WriteEndpointData( USB_EP0 , &Ep0.Tmp , 0 , 1 );
        Ep0.Tmp        = STRING_DESCRIPTOR;
        API_USBD_WriteEndpointData( USB_EP0 , &Ep0.Tmp , 1 , 1 );
        USB_CtrlRdBLen = 2;
        Ep0.All        = Ep0.All - 2;
        
        Ep0.Tmp        = 0;
        
        while( (USB_CtrlRdBLen < MG_USB_EP0_DSIZE) && (Ep0.All!=0))
        {
            if( ( USB_CtrlRdBLen % 2)==0)
            {
                API_USBD_WriteEndpointData( USB_EP0 , Ep0.Buf , USB_CtrlRdBLen , 1 );
                Ep0.Buf += 1;
            }
            else
            {
                API_USBD_WriteEndpointData( USB_EP0 , &Ep0.Tmp , USB_CtrlRdBLen , 1 );
            }
            
            Ep0.All -= 1;
            USB_CtrlRdBLen = USB_CtrlRdBLen + 1;
        }

        USB_SetEndpointTXSize(USB_EP0, USB_CtrlRdBLen);
        USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                                                                          
    }
    else if(Ep0.DataStage == DATASTAGE_STRING1)
    {
        USB_CtrlRdBLen = 0;
        Ep0.Tmp        = 0;
        
        while( (USB_CtrlRdBLen < MG_USB_EP0_DSIZE) && (Ep0.All!=0))
        {
            if( ( USB_CtrlRdBLen % 2)==0)
            {
                API_USBD_WriteEndpointData( USB_EP0 , Ep0.Buf , USB_CtrlRdBLen , 1 );
                Ep0.Buf += 1;
            }
            else
            {
                API_USBD_WriteEndpointData( USB_EP0 , &Ep0.Tmp , USB_CtrlRdBLen , 1 );
            }
            
            Ep0.All -= 1;
            USB_CtrlRdBLen = USB_CtrlRdBLen + 1;
        }

        USB_SetEndpointTXSize(USB_EP0, USB_CtrlRdBLen);
        USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);
    }
    else
    { 
        USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);                       // Set Rx/Tx STAL 
        if ( Ep0.DataStage == SETADDRESS )                                          // Different from other STATUSSTAGE(importent)
        { 
            __DRV_USB_SETADDRESS(Ep0.Tmp);
        }
    }
}

/**
 *******************************************************************************
 * @brief	   USB standard request.
 * @details     
 * @return      
 * @exception  No  
 * @note                     
 *******************************************************************************
 */
void sAPI_USBD_StandardRequest( void )
{ 
   if( Ep0.RxTx[0] & GET_REQUEST)
   {
       switch( Ep0.RxTx[1] )                                                                    // Request Code
       { 
           case GET_DESCRIPTOR:    
                                   Ep0.DataStage = DATASTAGE;
                                   if( g_UsbFun.pfGetDescriptor != NULL )
                                   {
                                       (*g_UsbFun.pfGetDescriptor)();
                                   }

                                   if( g_UsbFun.pfControlRead != NULL )
                                   {
                                       (*g_UsbFun.pfControlRead)();
                                   }
                                   break;
           case GET_CONFIGURATION: 
                                   Ep0.DataStage = DATASTAGE;
                                   Ep0.RxTx[0] = Ep0.ConfigurationValue;                        // This value get from SET_CONFIGURATION transaction
                                   Ep0.All = 1;                                                 // Only 1 byte transfer to the host

                                   if( g_UsbFun.pfControlRead != NULL )
                                   {
                                       (*g_UsbFun.pfControlRead)();
                                   }
                                   break;
           case GET_STATUS:       
                                   Ep0.DataStage = DATASTAGE;
                                   if( g_UsbFun.pfGetStatus != NULL )
                                   {
                                       (*g_UsbFun.pfGetStatus)();
                                   }

                                   if( g_UsbFun.pfControlRead != NULL )
                                   {
                                       (*g_UsbFun.pfControlRead)();
                                   }
                                   break;
           case GET_INTERFACE:     
                                   Ep0.DataStage = DATASTAGE;
                                   if( g_UsbFun.pfGetInterface != NULL )
                                   {
                                       (*g_UsbFun.pfGetInterface)();
                                   }

                                   if( g_UsbFun.pfControlRead != NULL )
                                   {
                                       (*g_UsbFun.pfControlRead)();
                                   }
                                   break;
           case SYNCH_FRAME:       
                                   Ep0.DataStage = STATUSSTAGE;
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   Ep0.All = 0;
                                   break;
           default:                
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);        // Set Rx/Tx STAL 
                                   break;         
       }
   }
   else
   {
       switch( Ep0.RxTx[1] )                                                                    // Request Code
       { 
           case SET_ADDRESS:       
                                   Ep0.DataStage = SETADDRESS;                                  // Different from other STATUSSTAGE
                                   Ep0.Tmp = Ep0.RxTx[2];
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   break;
           case SET_CONFIGURATION: 
                                   Ep0.DataStage = STATUSSTAGE;
                                   if( g_UsbFun.pfSetConfiguration != NULL )
                                   {
                                       (*g_UsbFun.pfSetConfiguration)();
                                   }                            
                                   break;
           case CLEAR_FRATURE:		
                                   Ep0.DataStage = STATUSSTAGE; 
                                   if( g_UsbFun.pfClearFeature != NULL )
                                   {
                                       (*g_UsbFun.pfClearFeature)();
                                   }            
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   break;
           case SET_FEATURE:       
                                   Ep0.DataStage = STATUSSTAGE;
                                   if( g_UsbFun.pfSetFeature != NULL )
                                   {
                                       (*g_UsbFun.pfSetFeature)();
                                   }   
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   break;
           case SET_INTERFACE:     
                                   Ep0.DataStage = STATUSSTAGE;
                                   if( g_UsbFun.pfSetInterface != NULL )
                                   {
                                       (*g_UsbFun.pfSetInterface)();
                                   }
                                   break;
           case SET_DESCRIPTOR:
           default:                
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);        // Set Rx/Tx STAL 
                                   break;         
       }
   }
}
/**
 *******************************************************************************
 * @brief	   USB Class Request 
 * @details     
 * @return      
 * @exception  No 
 * @note                     
 *******************************************************************************
 */
void sAPI_USBD_ClassRequest( void )
{ 
    
    if( Ep0.RxTx[0] & GET_REQUEST)
    {
        switch( Ep0.RxTx[1])  
        {
            case GET_IDLE:     
                              Ep0.DataStage = DATASTAGE;
                              //Ep0.RxTx[0]   = Mouse_CTR.IdleRate;
                              Ep0.RxTx[0]   = g_UsbEP1Ctr.IdleRate;
                              Ep0.All = 1;
                              break;
            case GET_PROTOCOL: 
                              Ep0.DataStage = DATASTAGE;
                              //Ep0.RxTx[0]   = Mouse_CTR.Protocol;
                              Ep0.RxTx[0]   = g_UsbEP1Ctr.Protocol;
                              Ep0.All = 1;
                              break;
            case GET_REPORT:   
                              Ep0.DataStage  = DATASTAGE;
                              Ep0.All = 1;
                              break; 
            default:
                              Ep0.DataStage = STATUSSTAGE;
                              break;
        }

       if( g_UsbFun.pfControlRead != NULL )
       {
           (*g_UsbFun.pfControlRead)();
       }
    }
    else
    {
        switch( Ep0.RxTx[1])  
        {
            case SET_IDLE:     
                               Ep0.DataStage = STATUSSTAGE;
                               //Mouse_CTR.IdleRate = Ep0.RxTx[3];
                               g_UsbEP1Ctr.IdleRate = Ep0.RxTx[3];
                               USB_SetEndpointTXSize(USB_EP0, 0);
                               USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);
                               break;
            case SET_PROTOCOL: 
                               Ep0.DataStage = STATUSSTAGE;
                               //Mouse_CTR.Protocol = Ep0.RxTx[2];
                               g_UsbEP1Ctr.Protocol = Ep0.RxTx[2];
                               USB_SetEndpointTXSize(USB_EP0, 0);
                               USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);
                               break;
            case SET_REPORT:   
                               Ep0.DataStage = STATUSSTAGE;
                               USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL); 
                      
                               Ep0.All = Ep0.RxTx[7];
                               Ep0.All <<= 8;
                               Ep0.All += Ep0.RxTx[6];
                               break;
            default:           
                               Ep0.DataStage = STATUSSTAGE;
                               USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);       
                               break; 
        }
    }
}
/**
 *******************************************************************************
 * @brief	   USB EP0 handle for receive data or SETUP. 
 * @details     
 * @return      
 * @exception  No 
 * @note                      
 *******************************************************************************
 */
void sAPI_USBD_ControlWrite( void )                                                        // Host Out , USB In ( Only for EPO )
{                                                                                                                                                                       
    Ep0.Buf = Ep0.RxTx;                                                                   // Move Buffer address to RxTx[8] array , Use for USB_CtrlRd();

    // Move Rx Data to RxTxBuf buffer
    if( g_UsbFun.pfEP0ReadData != NULL )
    {
       (*g_UsbFun.pfEP0ReadData)();
    }

    if ( Ep0.DataStage == SETUPSTAGE )                                                        
    {	                                                                                  
        Ep0.All = 0;                                                                      
        switch( Ep0.RxTx[0] & REQUEST_TYPE_MASK )                                         // Request Type
        {
            case STANDARD_REQUEST: 
                                   if( g_UsbFun.pfStandardRequest != NULL )
                                   {
                                       (*g_UsbFun.pfStandardRequest)();
                                   }
                                   break;
            case CLASS_REQUEST:    
                                   if( g_UsbFun.pfClassRequest != NULL )
                                   {
                                       (*g_UsbFun.pfClassRequest)();
                                   }
                                   break;
            default:               
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);   // Set Rx/Tx STAL 
                                   break;                       
        }
    }    
}


/**
 *******************************************************************************
 * @brief	   USB interrupt handle function.
 * @details     
 * @return      
 * @exception  No 
 * @note                     
 *******************************************************************************
 */

void sAPI_USB_IRQHandler( void )
{ 
    uint32_t        USBIRQ_Status;
    uint32_t        URBEPIRQ_Status1;
    uint8_t         USBIRQ_Tmp;

    //=========================================================================
    //Get USB Interrupt Flag
    USBIRQ_Status       =  USB_GetITAllFlagStatus();

    //=========================================================================
    //USB Bus event handle
    if((USBIRQ_Status & USB_IT_BUS)!=0 )                                                      
    { 
        //---------------------------------------------------------------------
        //Detect Bus Suspend 
        if((USBIRQ_Status & USB_IT_BUS_SUSF)==USB_IT_BUS_SUSF)                                 
        {
            USB_ClearITFlag(USB_IT_BUS_SUSF | USB_IT_BUS);
            
            Ep0.USBStatus |= USB_STATUS_BUS_SUSPEND;
            
            // To do......
        }
        else
        { 
            //---------------------------------------------------------------------
            //Detect Bus Reset.
            if((USBIRQ_Status & USB_IT_BUS_RSTF)==USB_IT_BUS_RSTF)                                
            { 
                USB_ClearITFlag(USB_IT_BUS_RSTF);
                USBIRQ_Tmp = 0x80;

                while( USBIRQ_Tmp  < 228)                                  /*!< By changing the parameter (128 ~ 255) to modify Reset debounce. */
                {
                    if(__DRV_USB_GETBUS_STATUS() & USB_BUS_SE0_STA)
                    {
                        USBIRQ_Tmp = USBIRQ_Tmp + 1;
                    }
                    else
                    {
                        USBIRQ_Tmp = 0;
                        break;
                    }                        
                }
                if( USBIRQ_Tmp != 0)
                {
                    //API_Mouse_Init();
                    if( NULL != g_UsbFun.pfUsbInit )
                    {
                        (*g_UsbFun.pfUsbInit)();
                    }
                    
                    
                    Ep0.USBStatus |= USB_STATUS_BUS_RESET;
                    // To do......
                }
            }
            //---------------------------------------------------------------------
            //Detect Bus Resume 
            else if((USBIRQ_Status & USB_IT_BUS_RSMF)==USB_IT_BUS_RSMF)                         
            { 
                USB_ClearITFlag(USB_IT_BUS_RSMF);
                
                Ep0.USBStatus |= USB_STATUS_BUS_RESUME;
                // To do......
            } 
            //---------------------------------------------------------------------
            //Detect USB bus change in STOP mode
            else if((USBIRQ_Status & USB_IT_BUS_RWKF) == USB_IT_BUS_RWKF)
            {
                USB_ClearITFlag(USB_IT_BUS_RWKF);
                USB_IT_Config( USB_IT_BUS_RWKF , DISABLE);
             
                Ep0.USBStatus |= USB_STATUS_BUS_BUSEVENT_WAKEUP;                
                // To do......
            }                
        }
    }
    //=========================================================================
    //ACK response to LPM
    #if MG_USB_LPM_EN == 1
        if( USBIRQ_Status & USB_IT_LPM)
        {
            Ep0.LPM_BLE = USB_GetLPMBESL();
            
            if(USB_GetLPMbRemoteWake()!=0)
            {
                Ep0.USBStatus |= USB_STATUS_RWEN_MASK;
            }
            else
            {
                Ep0.USBStatus &= (~USB_STATUS_RWEN_MASK);
            }
            Ep0.USBStatus = Ep0.USBStatus | USB_STATUS_BUS_SUSPEND;
            
            USB_ClearITFlag(USB_IT_LPM);
        }
    #endif
    //=========================================================================
    //Endpoint handle.
    else  
    {   
        //=====================================================================
        //Endpoint 1 TX (for mouse)
        if((USBIRQ_Status & USB_IT_EP1)==USB_IT_EP1)
        {
            USB_ClearEndpointFlag(USB_EP1,USB_EP_FLAG_TXDONE);
            
            //Mouse_CTR.Status &= (~USBA_Status_UpdateReport);
            g_UsbEP1Ctr.Status &= (~USBA_Status_UpdateReport);
        }
        //=====================================================================
        //Endpoint 2 control (for Keyboard MultiMedia)
        if((USBIRQ_Status & USB_IT_EP2)==USB_IT_EP2)
        {
            USB_ClearEndpointFlag(USB_EP2 , USB_EP_FLAG_TXDONE);

            g_UsbEP1Ctr.Status &= (~USBA_Status_UpdateReport); 
        }
        //=====================================================================
        //Endpoint 0 control
        if((USBIRQ_Status & USB_IT_EP0)==USB_IT_EP0)
        {
            URBEPIRQ_Status1 = USB_GetEndpointFlagStatus(USB_EP0);
            
            if((URBEPIRQ_Status1 & USB_EP_FLAG_TXDONE)==USB_EP_FLAG_TXDONE)
            {
                USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_TXDONE);
                
                if( g_UsbFun.pfControlRead != NULL )
                {
                    (*g_UsbFun.pfControlRead)();
                }
            }
            else if((URBEPIRQ_Status1 & USB_EP_FLAG_RXDONE)==USB_EP_FLAG_RXDONE)
            {
                USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_RXDONE);
                if( g_UsbFun.pfControlWrite != NULL )
                {
                    (*g_UsbFun.pfControlWrite)();
                }
            }
        }
    }	  
}



void Usb_StateHandler(void)
{
    if( g_UsbFun.pfStateEvent != NULL )
    {
        (*g_UsbFun.pfStateEvent)();
    }
}

/**
 *******************************************************************************
 * @brief	   USB state handler.  
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */
void sAPI_USBD_StateHandler(void)
{
    uint32_t USBHandlerStateTmp;
    
    USBHandlerStateTmp = ( Ep0.USBStatus & USB_STATUS_BUS_MASK);
    
    /*USB Flow function*/
    if(USBHandlerStateTmp!=0)
    {
        switch( USBHandlerStateTmp)
        {
            //============================================================================================
            // During handling the ohter functions USB bus happen suspend status. 
            case USB_STATUS_BUS_SUSPEND:
                Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_SUSPEND));
                //-------------------------------------------------------------------------
                //If host allow remote wakeup enable the other external wakeup signal.
                if(( Ep0.USBStatus & USB_STATUS_RWEN_MASK) == USB_STATUS_RWEN_ENABLE)
                {
                    //API_Mouse_WakeupIT_Cmd(ENABLE);

                    //To do......
                }
                USB_IT_Config( USB_IT_BUS_RWKF , ENABLE);               /*!< Enable USB Bus event wakeup interrupt in STOP mode.*/ 
                //STOP_WFI();
                //API_Mouse_Parameter_DeInit();
                break;
                
            //============================================================================================
            //Detect USB Bus no supsend in STOP mode.            
            case USB_STATUS_BUS_BUSEVENT_WAKEUP:
                Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_BUSEVENT_WAKEUP));

                // To do......
                break;
            //============================================================================================
            //During handling the other functions extern wakeup signal happen.
            case USB_STATUS_BUS_EXTIEVENT_WAKEUP:
                Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_EXTIEVENT_WAKEUP));
                //-------------------------------------------------------------------------
                //If host allow remote wakeup send remote wakeup signal to host.
                USB_TriggerRemoteWakeup();
                break;                                                       
            //============================================================================================
            //During handling the ohter functions USB bus happen suspend and resume status.
            case ( USB_STATUS_BUS_SUSPEND | USB_STATUS_BUS_RESUME):
                Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_SUSPEND)); 
                break;
            //============================================================================================
            //During handling the ohter function USB bus happen resume status.
            case (USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESUME):
            case (USB_STATUS_BUS_RESUME):
                Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~(USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESUME)));
                break;
            
            //============================================================================================
            case (USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESET):
            case USB_STATUS_BUS_RESET:
                Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~(USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESET)));
                // To do...

                break;
            default:                                                      
                // To do...

                break;
        }
        Ep0.USBStatus = Ep0.USBStatus & (~USBHandlerStateTmp);
    }
}







#endif




