
// Here, we mainly introduce the TH244A power supply mode and external interruption.20240603.
/*
Megawin M0 MCU has three power modes :Normal mode , Sleep mode and STOP mode.
Normal mode:all devices work
Sleep mode: some devices shutdown
STOP mode: all devices shutdown. User can select to start RTC or IWDT based on application environment.
In general, user can set MCU to work at STOP mode to keep the lowest power consumption.
*/
/*External interrupt : arduino's attachInterrupt(pin_Ext, ISR, Mode).
pin_Ext: external interrupt arduino pin number;
ISR: Interrupt Service Routine;
Mode: Interrupt trigger conditions. Here,Megawin M0 arduino package supports five Modes include Level and EDGE.
Level: LOW means low Level Trigger.
           HIGH means high Level Trigger
EDGE: FALLING means Trigger from high level to low level.
          RISING means Trigger from low level to high level.
          CHANGE means Trigger at FALLING or RISING.
*/
//There are some differences in interruption mode behavior under different power modes.
/*
When MCU works at Normal mode or Sleep mode, the attachInterrupt support real 5 Mode.
Level: LOW means low Level Trigger.
           HIGH means high Level Trigger
EDGE: FALLING means Trigger from high level to low level.
          RISING means Trigger from low level to high level.
          CHANGE means Trigger at FALLING or RISING.
*/
/*
When MCU works at STOP mode, the attachInterrupt support ONLY LEVEL Mode actually.
EDGE mode will be forced to set as LEVEL Mode.
Level: LOW means low Level Trigger.
           HIGH means high Level Trigger
EDGE: FALLING same as LOW : low Level Trigger.
          RISING same as HIGH : high Level Trigger.
          CHANGE same as LOW : low Level Trigger.
Suggest to set external interrupt mode as HIGH level or LOW level at STOP mode.
*/

// **** INCLUDES *****
#include "LowPower.h"

const int LEDpin = 13;
volatile int state = LOW;

void setup()
{
    pinMode( LEDpin,  OUTPUT);
}

void loop() 
{
    // Enter power down state for 8 s with ADC and BOD module disabled
    LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF);  
    
    // Do something here
    
    digitalWrite( LEDpin, state );
    state = !state;
    delay(4000);
}
