///////////////////////////////////////////////////
//
//	FILE:       MPC82_SPI_Demo.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.7.9
//	PURPOSE:    Demo SPI Function
//
///////////////////////////////////////////////////

//#define DEBUG
#ifdef DEBUG
#include "debug.h"
#endif
#define MEGAWINIC	MPC82G516
#define MPC82x54	1//For MPC82x52 & MPC82x54
#define MPC82G516	2
#if (MEGAWINIC==MPC82G516)
#include "REG_MPC82G516.H"
#else
#include "REG_MPC82L54.H"
#endif
unsigned char SPI_DATA[16];
unsigned char i=0;
///////////////////////////////////////////////////
//
//	Function:Interrupt_Init()
//	Input 1
//  enable EA & ESPII(82G516) or ESPI_ADC(82x52 or 82x54)
//	Input 0
//	Disable interrupt
//
///////////////////////////////////////////////////
void Interrupt_Init(unsigned char en)
{
	if(en)
	{
#if (MEGAWINIC==MPC82G516)
		IE = 0x80;
		AUXIE = 0x01;
#else
		IE = 0xa0;
#endif
	}
	else
	{
		EA = 0x00;
	}
}
///////////////////////////////////////////////////
//
//	Function:SPI_Init()
//  Input 1
//	Enable SPEN(Enable SPI) & MSTR(Set to Master Mode)
//	Input 0
//	Disable MSTR(Set to Slave Mode)
//
///////////////////////////////////////////////////
void SPI_Init(unsigned char mas)
{
	if(mas)
		SPCTL = 0xd0;                   //Enable SPI Master
	else
		SPCTL = 0x40;
}
///////////////////////////////////////////////////
//
//	Function:SPI_Interrupt()
//	82G516    SPI interrupt table is 43H
//	82x54(52) SPI interrupt table is 2BH
//
///////////////////////////////////////////////////
#if (MEGAWINIC==MPC82G516)
void SPI_interrupt() interrupt 8
#else
void SPI_interrupt() interrupt 5
#endif
{	
	SPSTAT=0x80;
	SPI_DATA[i++]=SPDAT;
}
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{
	unsigned char j;
	unsigned char k;
	Interrupt_Init(1);
    SPI_Init(0);				        //Enable SPI to Slave
	while (1)
	{
		if(i==16)
		{
			Interrupt_Init(0);
    		SPI_Init(1);				//Enable SPI to Master
			for (j=0;j<16;j++)
			{
				P14=0;						
				SPDAT = SPI_DATA[j];
				while(SPSTAT != 0x80){}
				SPSTAT = 0x80;
				P14=1;
				for (k=0;k<5;k++){}		//delay
			}
			i=0;
		}
	}
}
