///////////////////////////////////////////////////
//
//	FILE:       Megawin_LCMPanel_Demo.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.9.26
//	PURPOSE:    Demo LCM Panel Function
//
///////////////////////////////////////////////////

//#define DEBUG
#ifdef DEBUG
#include "debug.h"
#endif
#include "REG_MPC82G516.H"
sfr Data = 0x80;//P0;
sbit VO = P1^0;
sbit RS = P1^1;
sbit RW = P1^2;
sbit EN = P1^3;
//12Mhz
void delay_50us() using 1
{
    unsigned char ii=0x2e;
    while(ii--){}
}
void delay_2ms()
{
    unsigned char d=40;
    while(d--)
    {
        delay_50us();
    }
}
void LCD_Clear()
{
    RS = 0;
    EN = 1;
    Data = 0x01;//CLear Display
    EN = 0;
    delay_2ms();
}
void LCD_Return_Home()
{
    RS = 0;
    EN = 1;
    Data = 0x02;//
    EN = 0;
    delay_2ms();
}
void LCD_Function_Set()
{
    RS = 0;
    EN = 1;
    Data = 0x38;//Set Function 8bit 2line
    EN = 0;
    delay_50us();
}
void LCD_Display_Off()
{
    RS = 0;
    EN = 1;
    Data = 0x08;//Display Off
    EN = 0;
    delay_50us();
}
void LCD_Display_On(unsigned char cursor)
{
    RS = 0;
    EN = 1;
    Data = 0x0C | (cursor<<1);//Display On
    EN = 0;
    delay_50us();
}
void LCD_Show_Str(unsigned char *msg,unsigned char len,unsigned int delay)
{
    unsigned char i;
    unsigned int j;
    RS = 1;
    for(i=0;i<len;i++)
    {
        EN = 1;
        Data = msg[i];
        EN = 0;
        for(j=0;j<delay;j++)
            delay_50us();
    }
}
//80 is Line 1
//C0 is Line 2
void LCD_Set_Address(unsigned char add)
{
    RS = 0;
    EN = 1;
    Data = add;//Set Address
    EN = 0;
    delay_50us();
}
void LCD_Set_Shift(unsigned char mode)
{
    RS = 0;
    EN = 1;
    if(mode == 0)//Normal
        Data = 0x06;
    else if(mode == 1)//Shift to left
        Data = 0x07;
    else if(mode == 2)//Shift to right
        Data = 0x05;
    EN = 0;
    delay_50us();
}
void main( void )
{
    unsigned char i,j;
    unsigned char str1[]="  Megawin  MCU  ";
    unsigned char str2[]="LCM Sample code ";
    unsigned char str3[]="Wellcome   ";
    VO = 0;
    RW = 0;
    LCD_Function_Set();
    LCD_Clear();
    LCD_Display_On(0);
    LCD_Set_Address(0x8f);
    LCD_Set_Shift(1);
    LCD_Show_Str(str3,0x0B,0x800);
    for(j=0;j<3;j++)
    {
        LCD_Display_Off();
        for(i=0;i<100;i++)
            delay_2ms();
        LCD_Display_On(0);
        for(i=0;i<100;i++)
            delay_2ms();
    }
    LCD_Clear();
    LCD_Return_Home();
    LCD_Set_Shift(0);//Set to normal
    LCD_Set_Address(0x80);
    LCD_Show_Str(str1,0x10,1);
    LCD_Set_Address(0xC0);
    LCD_Show_Str(str2,0x10,1);
    while(1);
}

