///////////////////////////////////////////////////
//
//	FILE:       MPC82G516_2UART_Demo.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2007.6.6
//	PURPOSE:    Demo 2 UART Function for all speed
//
///////////////////////////////////////////////////
//#define DEBUG
#define BAUDRATE    B_115200
#define B_2400      0
#define B_4800      1
#define B_9600      2
#define B_19200     3
#define B_38400     4
#define B_57600     5
#define B_115200    6
#define B_230400    7

#include "REG_MPC82G516.H"
#ifdef DEBUG
#include "debug.h"
#endif
void Init_Uart(void);
void Init_Uart2(void);
void Output(char,unsigned char);
void UART2_Interrupt();
void UART_Interrupt();
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
    
void main(void)
{
    Init_Uart();                                //Initial UART
	while (1) {}
}
///////////////////////////////////////////////////
//
//	Function:Init_UART()
//  Initial UART at Mode 1 and use Timer1 at mode 2
//  We set buad rete is 4800
//  11MHz / 12 / 16 / 4800 = 11.93 => 12
//  TH = 256-12 = 0xf4
//
///////////////////////////////////////////////////
//
//  Initial UART2 at Mode 1 and use Timer1 at mode 2
//  We set buad rete is 4800
//  11MHz / 12 / 16 / 4800 = 11.93 => 12
//  S2BRT = 256-12 = 0xf4
//
///////////////////////////////////////////////////
void Init_Uart(void)
{
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    IE=0x90;                                    //EA & ES
    AUXIE=0x10;                                 //2UART interrupt
//    IP=0x10;
//    IPH=0x10;
#if BAUDRATE == B_2400
//  11MHz / 12 / 32 / 2400 => 12
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xf4;                                 //Set 2UART overflow rate
    AUXR2|=0x10;                                
#elif BAUDRATE == B_4800
//  11MHz / 12 / 16 / 4800 => 12
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xf4;                                 //Set 2UART overflow rate
    AUXR2=0x08;                                 //SMOD = 1,TX12 = 0 (/12)
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_9600
//  11MHz / 12 / 16 / 9600 => 6
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfa;                                   //Set Timer1 overflow rate
    TL1=0xfa;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xfa;                                 //Set 2UART overflow rate
    AUXR2=0x08;                                 //SMOD = 1,TX12 = 0 (/12)
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_19200
//  11MHz / 32 / 19200 => 18
    TH1=0xee;                                   //Set Timer1 overflow rate
    TL1=0xee;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xee;                                 //Set 2UART overflow rate
    AUXR2=0x44;                                 //T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_38400
//  11MHz / 16 / 38400 => 18
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xee;                                   //Set Timer1 overflow rate
    TL1=0xee;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xee;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_57600
//  11MHz / 16 / 57600 => 12
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xf4;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_115200
//  11MHz / 16 / 115200 => 6
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfa;                                   //Set Timer1 overflow rate
    TL1=0xfa;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xfa;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_230400
//  11MHz / 16 / 230400 => 3
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfd;                                   //Set Timer1 overflow rate
    TL1=0xfd;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xfd;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#endif
}
void UART_Interrupt() interrupt 4
{
    if(TI)              //check if interrupt caused by TI ?
        TI=0;           //clear TI

    if(RI)
    {                   //check if interrupt caused by RI ?
        RI=0;           //clear RI
        Output(1,SBUF); //Send data to UART_2 from UART_1
    }
}
void UART2_Interrupt() interrupt 12
{
    if(S2CON&0x02)      //check if interrupt caused by S2TI ?
        S2CON&=0xFD;    //clear S2TI

    if(S2CON&0x01)
    {                   //check if interrupt caused by S2RI ?
        S2CON&=0xFE;    //clear S2RI
        Output(2,S2BUF);//Send data to RS232 from UART_2
    }
}
///////////////////////////////////////////////////
//
//	Function:Output()
//  Output to RS232
//
///////////////////////////////////////////////////
void Output(char Select,unsigned char d)
{
    if(Select == 1)
        SBUF = d;
    else//2
        S2BUF = d;
}
