///////////////////////////////////////////////////
//
//	FILE:       MPC82G516_2UART_Demo.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2007.6.6
//	PURPOSE:    Demo 2 UART Function for all speed
//
///////////////////////////////////////////////////
#define DEBUG
#define BAUDRATE    B_9600
#define B_2400      0
#define B_4800      1
#define B_9600      2
#define B_19200     3
#define B_38400     4
#define B_57600     5
#define B_115200    6
#define B_230400    7

#include "REG_MPC82G516.H"
#ifdef DEBUG
#include "debug.h"
#endif
void Init_Uart(void);
void Init_Uart2(void);
void OutputHex(char,unsigned char);
void Output(char,unsigned char);
unsigned char ReceiverHex();
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
    
void main(void)
{
	unsigned int i=0;
    unsigned char xdata Receiver_Data[256];
#ifdef DEBUG
    Debug_clear_LCD();
#endif
    Init_Uart();                                //Initial UART
	for(i=0;i<256;i++)
    {
        Output(2,i);                            //Send data to RS232
        Receiver_Data[i]=ReceiverHex();
	}
	for(i=0;i<256;i++)
    {
        if((i | 0xf0)==0xf0)
        {
            Output(1,0xaa);                     //Enter
            Output(1,0xdd);
        }
        OutputHex(1,Receiver_Data[i]);          //Send data to RS232
#ifdef DEBUG
        Debug_show_msg_to_LCD(Receiver_Data[i]);
#endif
	}
	while (1) {}
}
///////////////////////////////////////////////////
//
//	Function:Init_UART()
//  Initial UART at Mode 1 and use Timer1 at mode 2
//  We set buad rete is 4800
//  11MHz / 12 / 16 / 4800 = 11.93 => 12
//  TH = 256-12 = 0xf4
//
///////////////////////////////////////////////////
//
//  Initial UART2 at Mode 1 and use Timer1 at mode 2
//  We set buad rete is 4800
//  11MHz / 12 / 16 / 4800 = 11.93 => 12
//  S2BRT = 256-12 = 0xf4
//
///////////////////////////////////////////////////
void Init_Uart(void)
{
#if BAUDRATE == B_2400
//  11MHz / 12 / 32 / 2400 => 12
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xf4;                                 //Set 2UART overflow rate
    AUXR2|=0x10;                                
#elif BAUDRATE == B_4800
//  11MHz / 12 / 16 / 4800 => 12
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xf4;                                 //Set 2UART overflow rate
    AUXR2=0x08;                                 //SMOD = 1,TX12 = 0 (/12)
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_9600
//  11MHz / 12 / 16 / 9600 => 6
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfa;                                   //Set Timer1 overflow rate
    TL1=0xfa;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xfa;                                 //Set 2UART overflow rate
    AUXR2=0x08;                                 //SMOD = 1,TX12 = 0 (/12)
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_19200
//  11MHz / 32 / 19200 => 18
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    TH1=0xee;                                   //Set Timer1 overflow rate
    TL1=0xee;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xee;                                 //Set 2UART overflow rate
    AUXR2=0x44;                                 //T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_38400
//  11MHz / 16 / 38400 => 18
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xee;                                   //Set Timer1 overflow rate
    TL1=0xee;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xee;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_57600
//  11MHz / 16 / 57600 => 12
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xf4;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_115200
//  11MHz / 16 / 115200 => 6
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfa;                                   //Set Timer1 overflow rate
    TL1=0xfa;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xfa;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#elif BAUDRATE == B_230400
//  11MHz / 16 / 230400 => 3
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfd;                                   //Set Timer1 overflow rate
    TL1=0xfd;
    TR1 =1;                                     //Start Timer1
//Uart2
    S2CON=0x50;                                 //Set UART Mode 1
    S2BRT=0xfd;                                 //Set 2UART overflow rate
    AUXR2=0x4c;                                 //SMOD = 1,T1X12 = S2TX12 = 1
    AUXR2|=0x10;                                //S2TR = 1
#endif
}
///////////////////////////////////////////////////
//
//	Function:OutputHex()
//  Output HEX to Char and a space
//
///////////////////////////////////////////////////
void OutputHex(char Select,unsigned char Uart_Data)
{
    unsigned char DataH,DataL;
    DataH = Uart_Data >> 4;
    DataL = Uart_Data & 0x0f;
    Output(Select,DataH);
    Output(Select,DataL);
    Output(Select,0x20);
}
///////////////////////////////////////////////////
//
//	Function:Output()
//  Output to RS232
//
///////////////////////////////////////////////////
void Output(char Select,unsigned char d)
{
    unsigned char T2;

    T2 = S2CON;
    if(Select == 1)
    {
        if(d>9 & d<16)
            SBUF = d + 0x37;
        else if(d<10)
            SBUF = d + 0x30;
        else if(d==0xaa)    //NewLine
            SBUF = 0x0a;
        else if(d==0xdd)    //Return
            SBUF = 0x0d;
        else
            SBUF = d;
        while(TI == 0){}    //Write transmitting has been finished
        TI = 0;
    }
    else//2
    {
        S2BUF = d;
        while(S2CON == T2){}
        S2CON = T2;
    }
}

unsigned char ReceiverHex()
{
    while(RI == 0){}
    RI = 0;
    return SBUF;
}
