

#include "REG_MPC82L52.h"

#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		ADC_Check_Cnt_Max	50
//XTAL = 11.0592MHz, PWM output 200Hz@P3.5
uCHAR	ADC_Value;
uCHAR	ADC_Check_100_Cnt;
uCHAR	ADC_Check_75_Cnt;
uCHAR	ADC_Check_50_Cnt;
uCHAR	ADC_Check_25_Cnt;


void PWM_Duty_00(void)
{
	CCAP1H = 0xFF;						//duty cycle = 00%
}

void PWM_Duty_25(void)
{
	CCAP1H = 0xC0;						//duty cycle = 25%
}

void PWM_Duty_50(void)
{
	CCAP1H = 0x80;						//duty cycle = 50%
}

void PWM_Duty_75(void)
{
	CCAP1H = 0x40;						//duty cycle = 75%
}

void PWM_Duty_100(void)
{
	CCAP1H = 0x00;						//duty cycle = 100%
}

void ADC_Start(void)
{
	ADCTL |= 0x08;
	while(!(ADCTL & 0x10));				//wait ADC finish conversion
	ADC_Value = ADCV;
	ADCTL &= 0xEF;						//clear ADC interrupt flag
}


void main(void)
{

	P1M0 = 0x02;						//P1.1 input only

	TMOD = 0x02;						//Timer0 mode2
	TH0 = 0xEE;
	TL0 = 0xEE;
	TR0 = 1;

	CMOD = 0x04;						//Timer0 overflow
	CCAPM1 = 0x42;						//set 8bit PWM
	CCON = 0x40;						//PCA run
	
	PWM_Duty_00();

	ADCTL = 0x81;						//enable ADC and select channel P1.1

	while(1){
		ADC_Start();

		if(ADC_Value <= 118)
		{
			ADC_Check_100_Cnt ++;
			if(ADC_Check_100_Cnt > ADC_Check_Cnt_Max)		//ADC de-bounce
			{
				ADC_Check_100_Cnt = 0;
				PWM_Duty_100();
			}else{
				ADC_Check_75_Cnt = 0;
				ADC_Check_50_Cnt = 0;
				ADC_Check_25_Cnt = 0;
			}
		}else if((ADC_Value >= 119) && (ADC_Value <= 161))
		{
			ADC_Check_75_Cnt ++;
			if(ADC_Check_75_Cnt > ADC_Check_Cnt_Max)		//ADC de-bounce
			{
				ADC_Check_75_Cnt = 0;
				PWM_Duty_75();
			}else{
				ADC_Check_100_Cnt = 0;
				ADC_Check_50_Cnt = 0;
				ADC_Check_25_Cnt = 0;
			}
		}else if((ADC_Value >= 162) && (ADC_Value <= 204))
		{
			ADC_Check_50_Cnt ++;
			if(ADC_Check_50_Cnt > ADC_Check_Cnt_Max)		//ADC de-bounce
			{
				ADC_Check_50_Cnt = 0;
				PWM_Duty_50();
			}else{
				ADC_Check_100_Cnt = 0;
				ADC_Check_75_Cnt = 0;
				ADC_Check_25_Cnt = 0;
			}
		}else if(ADC_Value >= 205)
		{
			ADC_Check_25_Cnt ++;
			if(ADC_Check_25_Cnt > ADC_Check_Cnt_Max)		//ADC de-bounce
			{
				ADC_Check_25_Cnt = 0;
				PWM_Duty_25();
			}else{
				ADC_Check_100_Cnt = 0;
				ADC_Check_75_Cnt = 0;
				ADC_Check_50_Cnt = 0;
			}
		}
	}
}