///////////////////////////////////////////////////
//
//	FILE:       MPC82G516_ADConver_Sample_for_C.c
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	PURPOSE:    Demo ADConver Function
//
///////////////////////////////////////////////////
#define     AP_End_Addr       0x0EFFF
#define     IAP_Start_Addr    0x0F000
#define     IAP_End_Addr      0x0FBFF
#define     Xtal_Freq         11059200          // Unit:Hz
#define     BaudRate          115200         
#define     ADC_Speed         0                 // 0 = 840 ADConver Cycle
                                                // 1 = 630 ADConver Cycle
                                                // 2 = 420 ADConver Cycle
                                                // 3 = 210 ADConver Cycle

#define     ADC_Channel       1                 // 0 = Port1.0 ; 1 = Port1.1
                                                // 2 = Port1.2 ; 3 = Port1.3
                                                // 4 = Port1.4 ; 5 = Port1.5
                                                // 6 = Port1.6 ; 7 = Port1.7

#define     ADC_Data_Out_Mode 1                 // 0=ADCH[b9-b2]:ADCL[b1-b0]
                                                // 1=ADCH[b9-b8]:ADCL[b7-b0] 
                                                 
#include    "REG_MPC82G516.H"

void Interrup_Init() ;
void ADConver_Init() ;
void UART_Init() ;
void UART_Send(unsigned char ) ;

///////////////////////////////////////////////////
//
//    MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{  
   Interrup_Init() ;

   UART_Init() ;

   ADConver_Init() ;

   while(1);
}

///////////////////////////////////////////////////
//
//    Interrupt Initial Setting
//
///////////////////////////////////////////////////
void Interrup_Init(void)
{  
   AUXIP = 0x00 ;
   AUXIPH = 0x00 ;
   AUXIE |= 0x02 ;
   EA = 1 ;
}

///////////////////////////////////////////////////
//
//    UART Initial Setting
//
///////////////////////////////////////////////////
void UART_Init(void)
{  
   AUXR2 |= 0x40 ;
   PCON |= 0x80 ;
   TMOD = 0x20 ;
   TH1 = TL1 = 256-(((2*Xtal_Freq)/BaudRate)/32) ;
   SCON = 0x50 ;
   TR1 = 1 ;
   TI = 1 ;
}

///////////////////////////////////////////////////
//
//    UART Data Send to PC
//
///////////////////////////////////////////////////
void UART_Send(unsigned char Send_Data)
{  
   while(TI == 0) ;
   TI = 0;
   SBUF = Send_Data;
}

///////////////////////////////////////////////////
//
//    ADConver Initial Setting
//
///////////////////////////////////////////////////
void ADConver_Init(void)
{  
   P1M0 = (0x01 << ADC_Channel) ; 
   P1M1 &= ((0xFE << ADC_Channel) | (0x7F >> (7-ADC_Channel))) ;
#if ADC_Data_Out_Mode
   AUXR |= 0x40 ;
#else 
   AUXR &= 0xBF ;
#endif
   ADCTL = ((ADC_Speed << 5) | ADC_Channel | 0x80) ;
   ADCTL |= 0x08 ;
}

///////////////////////////////////////////////////
//
//    ADConver Interrupt Service Routine
//
///////////////////////////////////////////////////
void ADConver_ISR(void) interrupt 9 using 0
{  

#if ADC_Data_Out_Mode

   UART_Send(ADCH) ;
   AUXR |= 0x40 ;
   UART_Send(ADCL) ;
#else 
   union{  
      unsigned char B[2] ;
      unsigned int W ;
   }Wtype;
   Wtype.W = 0x0000 ;
   Wtype.W = ADCH ;
   Wtype.W = Wtype.W<< 2 ;

   UART_Send(Wtype.B[0]) ;
   AUXR &= 0xBF ;
   Wtype.W += ADCL ;

   UART_Send(Wtype.B[1]) ;
#endif

   ADCTL = ((ADC_Speed << 5) | ADC_Channel | 0x80) ;
   ADCTL |= 0x08 ;
}


