///////////////////////////////////////////////////
//
//    FILE:       MPC82E(L)54_ADConver_Sample_for_ASM.A51
//    COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//    PURPOSE:    Demo ADConver Function
//
///////////////////////////////////////////////////
AP_End_Addr       EQU      033FFh
IAP_Start_Addr    EQU      03400h
IAP_End_Addr      EQU      037FFh
Xtal_Freq         EQU      11059200          // Unit:Hz
BaudRate          EQU      115200            // bps
T1_Value          EQU      0FAh              // 256-(((2*Xtal_Freq)/BaudRate)/32) 

ADC_Speed         EQU      0                 // 0 = 840 ADConver Cycle
                                             // 1 = 630 ADConver Cycle
                                             // 2 = 420 ADConver Cycle
                                             // 3 = 210 ADConver Cycle

ADC_Channel       EQU      1                 // 0 = Port1.0 ; 1 = Port1.1
                                             // 2 = Port1.2 ; 3 = Port1.3
                                             // 4 = Port1.4 ; 5 = Port1.5
                                             // 6 = Port1.6 ; 7 = Port1.7

$INCLUDE (REG_MPC82L54.INC)

TDATA             SEGMENT  DATA
                  RSEG     TDATA	
StackSpace:       DS       030h

CSEG              AT       00000h            //ORG 00000h
      JMP   START

CSEG              AT       0002Bh
      JMP   SPI_ADConver_ISR

CSEG              AT       00073h            //ORG 00073h
Using    0
START:
      MOV   SP,#(StackSpace-1)
///////////////////////////////////////////////////
//
//	   Main()
//
///////////////////////////////////////////////////
      CALL  Initerrupt_Init

      CALL  UART_Init

      CALL  ADConver_Init

      JMP   $

///////////////////////////////////////////////////
//
//	   Initerrupt_Init()
//
///////////////////////////////////////////////////
Initerrupt_Init:
      MOV   IP,#000h
      SETB  ESPIADC
      SETB  EA 
      RET   

///////////////////////////////////////////////////
//
//    UART Initial Setting
//
///////////////////////////////////////////////////
UART_Init:
      ORL   AUXR,#040h
      ORL   PCON,#080h
      MOV   TMOD,#020h
      MOV   TH1,#T1_Value
      MOV   TL1,#T1_Value
      MOV   SCON,#050h
      SETB  TR1
      SETB  TI 
      RET

///////////////////////////////////////////////////
//
//    UART Data Send to PC
//
///////////////////////////////////////////////////
UART_Send:
      JNB   TI,$
      CLR   TI
      MOV   SBUF,R7
      RET 
///////////////////////////////////////////////////
//
//    ADConver Initial Setting
//    
///////////////////////////////////////////////////
ADConver_Init:
      MOV   P1M0,#(001h SHL ADC_Channel)
      ANL   P1M1,#((0FEh SHL ADC_Channel) OR (7Fh SHR (7-ADC_Channel))) ;
      ORL   AUXR,#010h
      MOV   ADCTL,#((ADC_Speed SHL 5) OR ADC_Channel OR 0x80)
      ORL   ADCTL,#008h
      RET

///////////////////////////////////////////////////
//
//    ADConver Interrupt Service Routine
//
///////////////////////////////////////////////////
SPI_ADConver_ISR:
      PUSH  ACC
      PUSH  PSW
      PUSH  AR0
      PUSH  AR6
      PUSH  AR7
    
      MOV   A,ADCH
      MOV   R6,#000h
      MOV   R0,#002h
      CLR   C
Shift_Loop:
      RLC   A
      XCH   A,R6
      RLC   A
      XCH   A,R6
      DJNZ  R0,Shift_Loop

      MOV   R7,AR6
      CALL  UART_Send

      ADD   A,ADCL
      MOV   R7,A
      CALL  UART_Send

      POP   AR7
      POP   AR6
      POP   AR0
      POP   PSW
      POP   ACC

      MOV   ADCTL,#((ADC_Speed SHL 5) OR ADC_Channel OR 0x80)
      ORL   ADCTL,#008h
      RETI

END