/******************************************************************************
 * mainC51.C
 * Demo code for using MPC82G516 as a simple Flash memory (with 64K bytes)
 ******************************************************************************/

//select Master MCU to access the 64K Flash memory implemented by MPC82G516
//
#define MPC89_series  0  //1=select, 0=not_select
#define MPC82G516     1  //1=select, 0=not_select

/* Common knowledge about the Flash memory operation:

   (1) The Flash memory can only perform page erasing, not byte erasing.

   (2) Before a byte can be written into some address of the Flash memory,
       the page containing that address should have been erased previously,
       otherwise the writing will fail.

   (3) To modify only one byte of a page, the user should read out whole the
       page contents and store in a buffer (may be XRAM or another Flash page).
       Then, erase that page, and re-write the modified buffer data to that
       page.

   (4) For Megawin's Flash-based 8051 MCU, the page size is 512 bytes.
       That also means the start address of a page is located at:
       0x0000, 0x0200, 0x0400, 0x0600, .., 0xF800, 0xFA00, 0xFC00, 0xFE00.
       The address increment is 0x0200, which is equal to 512.
*/

#if MPC89_series
  #include "REG_MPC89L51-515.h" //for MPC89-series SFR definition
#endif

#if MPC82G516
  #include "REG_MPC82G516.h"    //for MPC82G516 SFR definition
#endif

#include "G516Flash.h" //for the 64K Flash memory implemented by MPC82G516

#include "Debug.h"     //for the GNU Debugger

/******************************************************************************/
void main(void)
{
unsigned int Flash_addr,i;
unsigned char Flash_data;

/*----------------------------------
; enable MPC82G516's Flash,
;   suppose the MCU speed is 12MHz
;----------------------------------*/

    G516Flash_enable(12); //'12' means the master MCU speed

/*------------------------------------------------------------
; erase the page to which you will write data,
;   suppose the page used to store data is located at 0x0200
;------------------------------------------------------------*/

    Flash_addr=0x0200;
    G516Flash_page_erase(Flash_addr);

/*----------------------------------------------------------------
; write data to MPC82G516's Flash
;   suppose write data to addresses: 0x0200,0x0201,0x0202,0x0203
;----------------------------------------------------------------*/

  //write 0x5A to address 0x0200

    Flash_addr=0x0200;
    Flash_data=0x5A;
    G516Flash_byte_program(Flash_addr,Flash_data);

  //write 0xA5 to address 0x0201

    Flash_addr=0x0201;
    Flash_data=0xA5;
    G516Flash_byte_program(Flash_addr,Flash_data);

  //write 0x55 to address 0x0202

    Flash_addr=0x0202;
    Flash_data=0x55;
    G516Flash_byte_program(Flash_addr,Flash_data);

  //write 0xAA to address 0x0203

    Flash_addr=0x0203;
    Flash_data=0xAA;
    G516Flash_byte_program(Flash_addr,Flash_data);

/*-----------------------------------------------------------------
; read data from MPC82G516's Flash
;   suppose read data from addresses: 0x0200,0x0201,0x0202,0x0203
;-----------------------------------------------------------------*/

  //read from address 0x0200

    Flash_addr=0x0200;
    Flash_data=G516Flash_byte_read(Flash_addr);
    Debug_show_msg_to_LCD(Flash_data); //show data on the GNU Debugger

  //read from address 0x0201

    Flash_addr=0x0201;
    Flash_data=G516Flash_byte_read(Flash_addr);
    Debug_show_msg_to_LCD(Flash_data); //show data on the GNU Debugger

  //read from address 0x0202

    Flash_addr=0x0202;
    Flash_data=G516Flash_byte_read(Flash_addr);
    Debug_show_msg_to_LCD(Flash_data); //show data on the GNU Debugger

  //read from address 0x0203

    Flash_addr=0x0203;
    Flash_data=G516Flash_byte_read(Flash_addr);
    Debug_show_msg_to_LCD(Flash_data); //show data on the GNU Debugger

/*--------------------------------------------------
; write data to MPC82G516's Flash
;   suppose write data to addresses: 0x0204~0x03FF
;--------------------------------------------------*/

    for(i=0x0204;i<0x0400;i++){
       Flash_addr=i;
       Flash_data=(char)i;
       G516Flash_byte_program(Flash_addr,Flash_data);
       }

/*---------------------------------------------------
; read data from MPC82G516's Flash
;   suppose read data from addresses: 0x0204~0x03FF
;---------------------------------------------------*/

    for(i=0x0204;i<0x0400;i++){
       Flash_addr=i;
       Flash_data=G516Flash_byte_read(Flash_addr);
       Debug_show_msg_to_LCD(Flash_data); //show data on the GNU Debugger
       if(Flash_data!=(char)i) for(;;);
       }


    while(1){}
}

/******************************************************************************/

