/*** Functions used by other modules ***/

/*
For C51, #include "G516Flash.h", to use the following functions:

  (1) G516Flash_enable(XTAL_freq);
  (2) G516Flash_disable();
  (3) G516Flash_mass_erase();
  (4) G516Flash_page_erase(page_address);
  (5) G516Flash_byte_program(byte_address,dta);
  (6) dta=G516Flash_byte_read(byte_address);
*/

//Mnemonic definition

#define G516Flash_enable       FlashG516_enable
#define G516Flash_disable      FlashG516_disable
#define G516Flash_mass_erase   FlashG516_mass_erase
#define G516Flash_page_erase   FlashG516_page_erase
#define G516Flash_byte_program FlashG516_byte_program
#define G516Flash_byte_read    FlashG516_byte_read

//Prototype definition

extern void G516Flash_enable(char XTAL_freq);
extern void G516Flash_disable(void);
extern void G516Flash_mass_erase(void);
extern void G516Flash_page_erase(int page_address);
extern void G516Flash_byte_program(int byte_address, char dta);
extern char G516Flash_byte_read(int byte_address);

