///////////////////////////////////////////////////
//
//	FILE:		Megawin_External_Memory.A51
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2008.1.28
//	PURPOSE:	External Memory demo and dual DPTR demo
//
///////////////////////////////////////////////////
#include "REG_MPC82G516.INC"
#include "Debug.INC"
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
;COPY_CARD_AREA             EQU 0C000H  ;0xC000-0xDFFF
;COPY_CARD_AREA_END         EQU COPY_CARD_AREA+2000H
;IAP_CARD_0xE000_0xFFFF     EQU 0E000H
;-------------------------------------------------------;
#if 1//64K Bytes
COPY_CARD_AREA             EQU 0C000H  ;0xC000-0xDFFF
#else//32K Bytes
COPY_CARD_AREA             EQU 06000H  ;0xC000-0xDFFF
#endif
COPY_CARD_AREA_END         EQU COPY_CARD_AREA+2000H
IAP_CARD_0xE000_0xFFFF     EQU 0E000H
;
    	ORG		0000H	
    	JMP		START
    	ORG		10H
START:
        MOV     SP,#40    ;!
        Debug_clear_LCD
        MOV     AUXR, #010H
        MOV     STRETCH, #023H
        LCALL   READ_IAR_CARD
        LCALL   DUMP_DATA_FROM_ERAM
        SJMP    $
DUMP_DATA_FROM_ERAM:
        MOV     DPTR,#COPY_CARD_AREA    ;0xC000
;---------------
n:   
        MOVX    A,@DPTR                 ;save Data---------------------------3
        Debug_show_msg_to_PC A
        INC     DPTR                    ;next source read point -------------2
        MOV     A,DPH
        CJNE    A,#high COPY_CARD_AREA_END,n
        RET
READ_IAR_CARD:
        ORL     AUXR1,#00000001b        ;select DPTR1 Source point
        MOV     DPTR,#IAP_CARD_0xE000_0xFFFF
        ANL     AUXR1,#11111110b        ;select DPTR0 Dest point
        MOV     DPTR,#COPY_CARD_AREA    ;0xC000
;---------------
next:   ORL     AUXR1,#00000001b        ;select DPTR1
        LCALL   Read_IAP                ;--------------------------------------------- 1
        INC     DPTR                    ;next source read point -------------2
        ANL     AUXR1,#11111110b        ;select DPTR0 Dest
        MOVX    @DPTR,A                 ;save Data---------------------------3
        INC     DPTR                    ;next dest save point
        MOV     A,DPH
        CJNE    A,#high COPY_CARD_AREA_END,next
        MOV     IFMT,#0                 ;Standby
        MOV     ISPCR,#0                ;set ISPEN=1 & wait
        RET
;-------------------------------------------------------;
;  Read to IAP Area Data
  ;Entry DPTR=Read point
  ;Exit  ACC=Read Data
;-------------------------------------------------------;
Read_IAP:
        MOV     ISPCR,#81H      ;Enable IAP to change flash
        MOV     IFMT,#1         ;IAP Flash Mode Table (Read Mode)
        MOV     IFADRH,DPH      ;IAP Flash Address High Byte
        MOV     IFADRL,DPL      ;IAP Flash Address Low Byte
        MOV     SCMD,#46H
        MOV     SCMD,#0B9H
        MOV     A,IFD           ;read IAP data
        RET
;-------------------------------------------------------;
;   Erase the IAP Area
;Entry DPTR=Erase Start point(512byte Start address of boundary unit )
;-------------------------------------------------------;
Erase_IAP_512:
        MOV     ISPCR,#81H      ;Enable IAP to change flash
        MOV     IFMT,#3         ;IAP Flash Mode Table (Erase Mode)
        MOV     IFADRH,DPH      ;IAP Flash Address High Byte
        MOV     IFADRL,DPL      ;IAP Flash Address Low Byte
        MOV     SCMD,#46H
        MOV     SCMD,#0B9H
        RET
;-------------------------------------------------------;
;   Write the IAP Area Data
;Entry DPTR=Write point
;Exit  ACC=Write Data
;-------------------------------------------------------;
Write_IAP:
        MOV     ISPCR,#81H      ;Enable IAP to change flash
        MOV     IFMT,#2         ;IAP Flash Mode Table (Write Mode)
        MOV     IFADRH,DPH      ;IAP Flash Address High Byte
        MOV     IFADRL,DPL      ;IAP Flash Address Low Byte
        MOV     IFD,A           ;read IAP data
        MOV     SCMD,#46H
        MOV     SCMD,#0B9H
        RET
    	END

