/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t test_flag = 0;
/* Private function prototypes -----------------------------------------------*/
void MY_VCMP_Init(void);

/* Private functions ---------------------------------------------------------*/

void delay(volatile uint32_t n)
{
  while (n--)
    ;
}

/* Case1: If the input voltage in PC5 is lower than 1.25 v(for 32 pin the voltage will be 0.785v),
          then uart1 print "Filter output is low".
   Case2: If the input voltage in PC5 is higher than 1.25 v,
          then uart1 print "Filter output is high".
   Note1: Interrupt occured when the filter output voltage is a rising edge as the configuration,
          which means that you should give PC5 a rising edge cross 1.25v to trigger VCMP interrupt.
   Note2: The uart1 will print message every 0.5 s
*/
int main(void)
{
  SystemCoreClockUpdate();

  uart1_init(24000000, 115200);
  MY_VCMP_Init();

  /* Infinite loop */
  while (1)
  {
    if (test_flag == 1)
    {
      test_flag = 0;
      printf("Filter Interrupt!\r\n");
    }

    if (VCMP_GetOutputStatus() != RESET)
      printf("Filter output is High\r\n");
    else
      printf("Filter output is Low\r\n");

    delay(1550000);
  }
}

void MY_VCMP_Init(void)
{
  VCMP_InitTypeDef VCMP_InitStruct;

  RCC_APBPeriphClockCmd(RCC_APBPeriph_LVDVC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);

  GPIO_Init(GPIOC, GPIO_Pin_5, GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH);
  GPIO_SetAFPin(GPIOC, GPIO_Pin_5, GPIO_AF15);

  VCMP_InitStruct.VcapDiv = VCMP_2P4_VCAPDIV;
  VCMP_InitStruct.Filter_Clk = VCMP_FILTER_CLK_PCLK;
  VCMP_InitStruct.NegPinSel = VCMP_INPUT_VCAPDIV;
  VCMP_InitStruct.PosPinSel = VCMP_INPUT_1;
  VCMP_InitStruct.Filter_Enable = VCMP_FILTER_ENABLE;
  VCMP_InitStruct.Fliter_Num = 0x8000;
  VCMP_Init(&VCMP_InitStruct);

  VCMP_ITConfig(VCMP_RISE_INT, ENABLE);
  VCMP_ITCmd(ENABLE);
  NVIC_SetPriority(VCMP_IRQn, 1);
  NVIC_EnableIRQ(VCMP_IRQn);
  VCMP_Cmd(ENABLE);
}

void VCMP_IRQHandler(void)
{
  if (VCMP_GetITStatus() != RESET)
  {
    test_flag = 1;
    VCMP_ClearITPendingBit();
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
