/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t *TransmitBuf, *ReceiveBuf;
uint16_t TransmitCount, ReceiveCount;
uint8_t TransmitComplateFlag, ReceiveComplateFlag;
uint8_t send_buf[] = "Papillon MCU Transmit and Receive Interrupt\r\nPlease Enter 10 Data\r\n";
uint8_t recv_buf[50];
UART_InitTypeDef UART_InitStructure;

/* Private function prototypes -----------------------------------------------*/
void UART_Transmit_IT(UART_TypeDef* UARTx, uint8_t *pData, uint16_t Size);
void UART_Receive_IT(UART_TypeDef* UARTx, uint8_t *pData, uint16_t Size);

/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

int main(void)
{

  SystemCoreClockUpdate();

  /*
    PD5 UART1_TX
    PD6 UART1_RX
   */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);
  GPIO_Init(GPIOD, GPIO_Pin_5 | GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_OTYPE_PP | GPIO_SPEED_HIGH | GPIO_AF7);

  /* Enable UART1 */
  RCC_APBPeriphClockCmd(RCC_APBPeriph_UART1, ENABLE);
  UART_DeInit(UART1);

  /* Config NVIC UART1 Interrupt */
  NVIC_SetPriority(UART1_IRQn, 1);
  NVIC_EnableIRQ(UART1_IRQn);

  /* UART1 Config Init Param */
  UART_InitStructure.UART_BandDouble = UART_BandDouble_Enable;
  UART_InitStructure.UART_BaudRate = 115200;
  UART_InitStructure.UART_BaudRateMode = UART_BaudRateMode_Self;
  UART_InitStructure.UART_WordLength = UART_WordLength_8b;
  UART_Init(UART1, &UART_InitStructure);

  UART_Cmd(UART1, ENABLE);

  TransmitComplateFlag = 0;
  UART_Transmit_IT(UART1, send_buf, sizeof(send_buf));
  while (!TransmitComplateFlag)
    ;

  /* Infinite loop */
  while (1)
  {
    ReceiveComplateFlag = 0;
    UART_Receive_IT(UART1, recv_buf, 10);
    while (!ReceiveComplateFlag)
      ;

    TransmitComplateFlag = 0;
    UART_Transmit_IT(UART1, recv_buf, 10);
    while (!TransmitComplateFlag)
      ;
  }
}

void UART_Transmit_IT(UART_TypeDef *UARTx, uint8_t *pData, uint16_t Size)
{
  TransmitBuf = pData;
  TransmitCount = Size;

  /* Enable UART1 Transmit Complate Interrupt */
  UART_ITConfig(UARTx, UART_IT_TI, ENABLE);

  UART_WriteData(UARTx, *TransmitBuf++);
  TransmitCount--;
}

void UART_Receive_IT(UART_TypeDef *UARTx, uint8_t *pData, uint16_t Size)
{
  ReceiveBuf = pData;
  ReceiveCount = Size;

  UART_ClearFlag(UARTx, UART_FLAG_RI);

  /* Enable UART1 Transmit Complate Interrupt */
  UART_ITConfig(UARTx, UART_IT_RI, ENABLE);
}

void UART1_IRQHandler(void)
{
  if (UART_GetFlagStatus(UART1, UART_FLAG_TI) != RESET)
  {
    if (TransmitCount--)
    {
      UART_WriteData(UART1, *TransmitBuf++);
    }
    /* Transmit end */
    else
    {
      UART_ITConfig(UART1, UART_IT_TI, DISABLE);
      TransmitComplateFlag = 1;
    }
    UART_ClearFlag(UART1, UART_FLAG_TI);
  }
  else if (UART_GetFlagStatus(UART1, UART_FLAG_RI) != RESET)
  {
    if (ReceiveCount--)
    {
      *ReceiveBuf++ = UART_ReadData(UART1);
    }
    if (ReceiveCount == 0)
    {
      UART_ReadData(UART1);
      UART_ITConfig(UART1, UART_IT_RI, DISABLE);
      ReceiveComplateFlag = 1;
    }
    UART_ClearFlag(UART1, UART_FLAG_RI);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
