/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "rtc.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
RTC_TimeTypeDef RTC_TimeStruct;
RTC_DateTypeDef RTC_DateStruct;
RTC_AlarmTypeDef RTC_AlarmStruct;

RTC_TimeTypeDef tTime;
RTC_DateTypeDef tDate;
RTC_AlarmTypeDef tAlarm;

extern uint8_t alarm1Flag;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
void delay(volatile uint32_t n)
{
  while (n--)
    ;
}

int main(void)
{
  SystemCoreClockUpdate();
  uart1_init(24000000, 115200);
  My_RTC_Init();
  printf("RTC Calendar start!!\r\n");

  /* Infinite loop */
  while (1)
  {
    do
    {
      RTC_GetTime(RTC_Format_BIN, &RTC_TimeStruct);
      RTC_GetDate(RTC_Format_BIN, &RTC_DateStruct);
    } while (RTC_TimeStruct.RTC_Seconds == tTime.RTC_Seconds);

    tTime = RTC_TimeStruct;
    tDate = RTC_DateStruct;
    delay(100);

    if (alarm1Flag)
    {
      printf("alarm cen=%d %02d/%02d/%02d weekday=%d, AMPM=%d %02d:%02d:%02d \r\n", tDate.RTC_Cen,
                                                                                    tDate.RTC_Year,
                                                                                    tDate.RTC_Month,
                                                                                    tDate.RTC_Date,
                                                                                    tDate.RTC_WeekDay,
                                                                                    tTime.RTC_H12, 
                                                                                    tTime.RTC_Hours,
                                                                                    tTime.RTC_Minutes,
                                                                                    tTime.RTC_Seconds);
      alarm1Flag = 0;
    }
    else
    {
      printf("time  cen=%d %02d/%02d/%02d weekday=%d, AMPM=%d %02d:%02d:%02d \r\n", tDate.RTC_Cen,
                                                                                    tDate.RTC_Year,
                                                                                    tDate.RTC_Month,
                                                                                    tDate.RTC_Date,
                                                                                    tDate.RTC_WeekDay,
                                                                                    tTime.RTC_H12, 
                                                                                    tTime.RTC_Hours,
                                                                                    tTime.RTC_Minutes,
                                                                                    tTime.RTC_Seconds);
    }
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
