/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(uint32_t n)
{
  while (n--)
    ;
}

int main(void)
{
  SystemCoreClockUpdate();

  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);

  GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_MODE_IN | GPIO_PUPD_UP); // Set exit IO
  GPIO_EXTIConfig(GPIOC, GPIO_Pin_6, GPIO_EXTI_IT_ENABLE | GPIO_EXTI_TRIGGER_FALLING);

  GPIO_Init(GPIOC, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP);
  GPIO_Init(GPIOC, GPIO_Pin_3, GPIO_MODE_OUT | GPIO_OTYPE_PP);
  GPIO_ResetBits(GPIOC, GPIO_Pin_4); // Turn on LED1

  NVIC_SetPriority(GPIOC_IRQn, 1);
  NVIC_EnableIRQ(GPIOC_IRQn);

  delay(1000000);
  GPIO_Init(GPIOC,GPIO_Pin_4,GPIO_MODE_IN | GPIO_PUPD_UP | GPIO_OTYPE_OD);
  GPIO_Init(GPIOC,GPIO_Pin_3,GPIO_MODE_IN | GPIO_PUPD_UP | GPIO_OTYPE_OD);

  /* Enter DEEPSLEEP Mode */
  PWR_EnterDEEPSLEEPMode();
 
 GPIO_Init(GPIOC, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP);

  /* Infinite loop */
  while (1)
  {
    /* LED1 blink */
    GPIO_ToggleBits(GPIOC, GPIO_Pin_4);
    delay(1000000);
  }
}

/**
  * @brief This function handles GPIOC Interrupt.
  */
void GPIOC_IRQHandler(void)
{
  if (GPIO_EXTI_GetFlagStatus(GPIOC, GPIO_Pin_6))
  {
    GPIO_EXTI_ClearFlag(GPIOC, GPIO_Pin_6);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
