/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void PCA_Init(void);
/* Private functions ---------------------------------------------------------*/

/* PCA channel2(PA3) will put out pwm with a frequeny of 22.888 Hz */
int main(void)
{
  SystemCoreClockUpdate();

  PCA_Init();

  /* Infinite loop */
  while (1)
  {
    ;
  }
}

void PCA_Init(void)
{
  RCC_APBPeriphClockCmd(RCC_APBPeriph_PCA, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

  PCA_BaseInitTypeDef PCA_InitStruct;
  PCA_OC_InitTypeDef PCA_OC_InitStruct;

  /* Initialize the output pwm pin */
  GPIO_Init(GPIOA, GPIO_Pin_3, GPIO_SPEED_HIGH | GPIO_PUPD_UP | GPIO_OTYPE_PP);
  GPIO_SetAFPin(GPIOA, GPIO_Pin_3, GPIO_AF2);

  /* PCA base initialization, Clock = PCLK/8 = 24M/8 = 3MHz*/
  PCA_InitStruct.ClkSrcSel = PCA_CLOCK_SOURCE_PCLKDIV8;
  PCA_InitStruct.RunInIdleMode = PCA_IDLEMODE_DISABLE;
  PCA_BaseInit(&PCA_InitStruct);

  /* PCA output pwm configuration */
  PCA_OC_InitStruct.CompareEnable = PCA_OC_ENABLE;
  PCA_OC_InitStruct.PwmEnable = PCA_PWM_ENABLE;
  PCA_OC_InitStruct.TogEnable = PCA_TOG_ENABLE;
  /*PCA_CH2 toggle depends not on Period, output pwm always be 3MHz / (65535 * 2) = 22.888 Hz */
  PCA_OC_InitStruct.Period = 3000;
  PCA_OC_InitStruct.Channel = PCA_CHANNEL_2;
  PCA_OC_Config(&PCA_OC_InitStruct);
  PCA_OC_Cmd(PCA_OC_InitStruct.Channel, ENABLE);

  /* PCA enable */
  PCA_Cmd(ENABLE);
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
