/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
LPUART_InitTypeDef LPUART_InitStructure;

/* Private function prototypes -----------------------------------------------*/
void LPUART_Transmit(LPUART_TypeDef* LPUARTx, uint8_t *pData, uint16_t Size);

/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

int main(void)
{
  uint8_t value;

  SystemCoreClockUpdate();

  /*
    PC5 LPUART_TX
    PC6 LPUART_RX
   */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);
  GPIO_Init(GPIOC, GPIO_Pin_5 | GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_OTYPE_PP | GPIO_SPEED_HIGH | GPIO_AF5);

  /* Enable LPUART */
  RCC_APBPeriphClockCmd(RCC_APBPeriph_LPUART, ENABLE);
  LPUART_DeInit(LPUART);

  /* LPUART Config Init Param */
  LPUART_InitStructure.LPUART_BandDouble = LPUART_BandDouble_Enable;
  LPUART_InitStructure.LPUART_BaudRateMode = LPUART_BaudRateMode_Self;
  LPUART_InitStructure.LPUART_BaudRate = 115200;
  LPUART_InitStructure.LPUART_LowPower = LPUART_LowPower_Disable;
  LPUART_InitStructure.LPUART_ClkSel = LPUART_ClkSel_PCLK;
  LPUART_InitStructure.LPUART_ClkDivision = LPUART_CLK_DIV1;
  LPUART_InitStructure.LPUART_WordLength = LPUART_WordLength_8b;
  LPUART_Init(LPUART, &LPUART_InitStructure);

  LPUART_Cmd(LPUART, ENABLE);

  LPUART_Transmit(LPUART, "LPUART Polling Test, Please enter some character.\r\n", sizeof("LPUART Polling Test, Please enter some character.\r\n"));

  LPUART_ITConfig(LPUART, LPUART_IT_TI | LPUART_IT_RI, ENABLE);

  /* Infinite loop */
  while (1)
  {
    while (LPUART_GetFlagStatus(LPUART, LPUART_FLAG_RI) == RESET)
      ;
    value = LPUART_ReadData(LPUART);
    LPUART_ClearFlag(LPUART, LPUART_FLAG_RI);

    LPUART_WriteData(LPUART, value);
    while (LPUART_GetFlagStatus(LPUART, LPUART_FLAG_TI) == RESET)
      ;
    LPUART_ClearFlag(LPUART, LPUART_FLAG_TI);
  }
}

void LPUART_Transmit(LPUART_TypeDef *LPUARTx, uint8_t *pData, uint16_t Size)
{
  uint16_t Count;

  if (LPUARTx == LPUART)
    NVIC_DisableIRQ(LPUART_IRQn);

  LPUART_ITConfig(LPUARTx, LPUART_IT_TI, ENABLE);

  Count = Size;
  while (Count--)
  {
    LPUART_WriteData(LPUARTx, *pData++);
    while (LPUART_GetFlagStatus(LPUARTx, LPUART_FLAG_TI) == RESET)
      ;
    LPUART_ClearFlag(LPUARTx, LPUART_FLAG_TI);
  }

  LPUART_ITConfig(LPUARTx, LPUART_IT_TI, DISABLE);
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
