/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t *TransmitBuf, *ReceiveBuf;
uint16_t TransmitCount, ReceiveCount;
uint8_t TransmitComplateFlag, ReceiveComplateFlag;
uint8_t send_buf[] = "LPUART Transmit and Receive Interrupt\r\nPlease Enter 10 Data\r\n";
uint8_t recv_buf[50];
LPUART_InitTypeDef LPUART_InitStructure;

/* Private function prototypes -----------------------------------------------*/
void LPUART_Transmit_IT(LPUART_TypeDef* LPUARTx, uint8_t *pData, uint16_t Size);
void LPUART_Receive_IT(LPUART_TypeDef* LPUARTx, uint8_t *pData, uint16_t Size);

/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

int main(void)
{
  SystemCoreClockUpdate();

  /*
    PC5 LPUART_TX
    PC6 LPUART_RX
   */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);
  GPIO_Init(GPIOC, GPIO_Pin_5 | GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_OTYPE_PP | GPIO_SPEED_HIGH | GPIO_AF5);

  /* Enable LPUART */
  RCC_APBPeriphClockCmd(RCC_APBPeriph_LPUART, ENABLE);
  LPUART_DeInit(LPUART);

  /* Config NVIC LPUART Interrupt */
  NVIC_SetPriority(LPUART_IRQn, 1);
  NVIC_EnableIRQ(LPUART_IRQn);

  /* LPUART Config Init Param */
  LPUART_InitStructure.LPUART_BandDouble = LPUART_BandDouble_Enable;
  LPUART_InitStructure.LPUART_BaudRate = 115200;
  LPUART_InitStructure.LPUART_BaudRateMode = LPUART_BaudRateMode_Self;
  LPUART_InitStructure.LPUART_WordLength = LPUART_WordLength_8b;
  LPUART_InitStructure.LPUART_ClkDivision = LPUART_CLK_DIV1;
  LPUART_InitStructure.LPUART_ClkSel = LPUART_ClkSel_PCLK;
  LPUART_InitStructure.LPUART_LowPower = LPUART_LowPower_Disable;
  LPUART_Init(LPUART, &LPUART_InitStructure);

  LPUART_Cmd(LPUART, ENABLE);

  TransmitComplateFlag = 0;
  LPUART_Transmit_IT(LPUART, send_buf, sizeof(send_buf));
  while (!TransmitComplateFlag)
    ;

  /* Infinite loop */
  while (1)
  {
    ReceiveComplateFlag = 0;
    LPUART_Receive_IT(LPUART, recv_buf, 10);
    while (!ReceiveComplateFlag)
      ;

    TransmitComplateFlag = 0;
    LPUART_Transmit_IT(LPUART, recv_buf, 10);
    while (!TransmitComplateFlag)
      ;
  }
}

void LPUART_Transmit_IT(LPUART_TypeDef *LPUARTx, uint8_t *pData, uint16_t Size)
{
  TransmitBuf = pData;
  TransmitCount = Size;

  /* Enable LPUART Transmit Complate Interrupt */
  LPUART_ITConfig(LPUARTx, LPUART_IT_TI, ENABLE);

  LPUART_WriteData(LPUARTx, *TransmitBuf++);
  TransmitCount--;
}

void LPUART_Receive_IT(LPUART_TypeDef *LPUARTx, uint8_t *pData, uint16_t Size)
{
  ReceiveBuf = pData;
  ReceiveCount = Size;

  LPUART_ClearFlag(LPUARTx, LPUART_FLAG_RI);

  /* Enable LPUART Transmit Complate Interrupt */
  LPUART_ITConfig(LPUARTx, LPUART_IT_RI, ENABLE);
}

void LPUART_IRQHandler(void)
{
  if (LPUART_GetFlagStatus(LPUART, LPUART_FLAG_TI) != RESET)
  {
    if (TransmitCount--)
    {
      LPUART_WriteData(LPUART, *TransmitBuf++);
    }
    /* Transmit end */
    else
    {
      LPUART_ITConfig(LPUART, LPUART_IT_TI, DISABLE);
      TransmitComplateFlag = 1;
    }
    LPUART_ClearFlag(LPUART, LPUART_FLAG_TI);
  }
  else if (LPUART_GetFlagStatus(LPUART, LPUART_FLAG_RI) != RESET)
  {
    if (ReceiveCount--)
    {
      *ReceiveBuf++ = LPUART_ReadData(LPUART);
    }
    if (ReceiveCount == 0)
    {
      LPUART_ReadData(LPUART);
      LPUART_ITConfig(LPUART, LPUART_IT_RI, DISABLE);
      ReceiveComplateFlag = 1;
    }
    LPUART_ClearFlag(LPUART, LPUART_FLAG_RI);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
