/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

int main(void)
{
  /* Enable GPIO clock */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA | RCC_AHBPeriph_GPIOC | RCC_AHBPeriph_GPIOD, ENABLE);

  /* Configure PC5 and PC6 as input pull-up mode */
  GPIO_Init(GPIOC, GPIO_Pin_5 | GPIO_Pin_6, GPIO_MODE_IN | GPIO_PUPD_UP);

  /* Configure PC3 and PC4 in output push-pull mode */
  GPIO_Init(GPIOC, GPIO_Pin_3 | GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH);
  GPIO_SetBits(GPIOC, GPIO_Pin_3 | GPIO_Pin_4); // LED turn off

  /* Infinite loop */
  while (1)
  {
    if (GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_5) == Bit_RESET)
    {
      GPIO_ResetBits(GPIOC, GPIO_Pin_3); // LED2 turn on
    }
    else
    {
      GPIO_SetBits(GPIOC, GPIO_Pin_3); // LED2 turn off
    }

    if (GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_6) == Bit_RESET)
    {
      GPIO_ResetBits(GPIOC, GPIO_Pin_4); // LED1 turn on
    }
    else
    {
      GPIO_SetBits(GPIOC, GPIO_Pin_4); // LED1 turn off
    }
  }
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
