/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint32_t OverflowCnt;
uint16_t channel_value[20] = {0};
uint8_t buffer_index = 0;
uint8_t arry_index = 0;
/* Private function prototypes -----------------------------------------------*/
void TIM1_Init(void);
void MY_ADC_Init(void);
/* Private functions ---------------------------------------------------------*/

/* The uart1 will print ADC conversion value of channel0(PC6) every 1 second */
int main(void)
{
  SystemCoreClockUpdate();

  MY_ADC_Init();
  uart1_init(24000000, 115200);

  MY_ADC_Init();
  TIM1_Init();

  /* Infinite loop */
  while (1)
  {
    if (OverflowCnt == 10)
    {
      OverflowCnt = 0;
      buffer_index = 0;
      printf("ADC sample values are :\r\n");
      for (arry_index = 0; arry_index < 10; arry_index++)
        printf("%-5d", channel_value[arry_index]);
      printf("\r\n");
    }
  }
}

/**
  * @brief  ADC Configuration(Channel 0, single mode, no auto acceleration, 
  *         64 clock division, TIM1 interrupt flag trigger, sample time: 8 cycles)
  * @note   Channel_0(PC6)
  * @retval None
  */
void MY_ADC_Init(void)
{
  ADC_InitTypeDef ADC_InitStruct = {0};

  RCC_APBPeriphClockCmd(RCC_APBPeriph_ADC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);

  GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);

  ADC_InitStruct.ADC_SamplingTime = ADC_SAMPLE_8CYCLE;
  ADC_InitStruct.ADC_SingleChannelSel = ADC_SINGLE_CHANNEL_0;
  ADC_InitStruct.ADC_SingleContinueMode = ADC_MODE_SINGLE;
  ADC_InitStruct.ADC_ClkSel = ADC_CLOCK_PCLK_DIV64;
  ADC_InitStruct.ADC_CircleMode = ADC_MULTICHANNEL_NONCIRCLE;
  ADC_InitStruct.ADC_AutoAccumulation = ADC_AUTOACC_DISABLE;
  ADC_InitStruct.ADC_ExternalTrigConv1 = ADC_EXTTRIG1_TIM1;
  ADC_InitStruct.ADC_ExternalTrigConv2 = ADC_EXTTRIG2_TIM1;
  ADC_Init(&ADC_InitStruct);

  ADC_Cmd(ENABLE);
  ADC_ITConfig(ADC_IT_CHANNEL0, ENABLE);
  NVIC_SetPriority(ADC_IRQn, 2);
  NVIC_EnableIRQ(ADC_IRQn);
}

/**
  * @brief This function handles ADC Interrupt.
  */
void ADC_IRQHandler(void)
{
  if (ADC_GetFlagStatus(ADC_IT_CHANNEL0) != RESET)
  {
    ADC_ClearFlag(ADC_IT_CHANNEL0);

    OverflowCnt++;
    TIM_ClearFlag(TIM1, TIM_FLAG_Update);

    channel_value[buffer_index++] = ADC_GetConversionValue(ADC_SINGLE_CHANNEL_0);
  }
}

/* TIM1 every 0.1s generate a interrupt flag */
void TIM1_Init(void)
{
  TIM_TimeBaseInitTypeDef Base_Initstruct;

  RCC_APBPeriphClockCmd(RCC_APBPeriph_TIM1, ENABLE);
  RCC_APBPeriphClockCmd(RCC_APBPeriph_TIM2, ENABLE);

  Base_Initstruct.TIM_ClockDivision = TIM_CKD_DIV1;
  Base_Initstruct.TIM_CounterMode = TIM_CounterMode_Up;
  Base_Initstruct.TIM_Period = 18750;
  Base_Initstruct.TIM_Prescaler = 128;
  Base_Initstruct.TIM_RepetitionCounter = 0;
  TIM_TimeBaseInit(TIM1, &Base_Initstruct);

  TIM_ITConfig(TIM1, TIM_IT_Update, ENABLE);
  TIM_Cmd(TIM1, ENABLE);
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
