/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define CONVERSION_NUM  50       // define the total conversion times of all channels
#define NumOfChannels   5        // define number of channels

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint16_t Channel_0_Value[CONVERSION_NUM / NumOfChannels];
uint16_t Channel_1_Value[CONVERSION_NUM / NumOfChannels];
uint16_t Channel_2_Value[CONVERSION_NUM / NumOfChannels];
uint16_t Channel_3_Value[CONVERSION_NUM / NumOfChannels];
uint16_t Channel_4_Value[CONVERSION_NUM / NumOfChannels];
uint8_t complete_flag = 0;
uint8_t buffer_index = 0;
/* Private function prototypes -----------------------------------------------*/
void MY_ADC_Init(void);
/* Private functions ---------------------------------------------------------*/

/**
  * @note You could get conversion values printed in uart1 of ADC 
  *       Channel_0 ~ Channel_4(PC6, PC3, PC4, PD2, PD3)
  */
int main(void)
{
  SystemCoreClockUpdate();
  uart1_init(24000000, 115200);
  MY_ADC_Init();

  /* Infinite loop */
  while (1)
  {
    if (complete_flag == 1)
    {
      printf("CH0:  CH1:  CH2:  CH3:  CH4:\r\n");
      for (buffer_index = 0; buffer_index < CONVERSION_NUM / NumOfChannels; buffer_index++)
      {
        printf("%-5d %-5d %-5d %-5d %-5d\r\n", Channel_0_Value[buffer_index],
                                               Channel_1_Value[buffer_index],
                                               Channel_2_Value[buffer_index],
                                               Channel_3_Value[buffer_index],
                                               Channel_4_Value[buffer_index]);
      }
      complete_flag = 0;
    }
  }
}

/**
  * @brief  ADC Configuration(Channel0 ~ Channel4, 10 conversions for each channel, continue mode, 
  *         no auto acceleration, 64 clock division, software start, sample time: 8 cycles)
  * @note   Channel_0 ~ Channel_4(PC6, PC3, PC4, PD2, PD3)
  * @retval None
  */
void MY_ADC_Init(void)
{
  ADC_InitTypeDef ADC_InitStruct = {0};

  RCC_APBPeriphClockCmd(RCC_APBPeriph_ADC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC | RCC_AHBPeriph_GPIOD, ENABLE);

  GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);
  GPIO_Init(GPIOC, GPIO_Pin_3, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);
  GPIO_Init(GPIOC, GPIO_Pin_4, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);
  GPIO_Init(GPIOD, GPIO_Pin_2, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);
  GPIO_Init(GPIOD, GPIO_Pin_3, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);

  ADC_InitStruct.ADC_SamplingTime = ADC_SAMPLE_8CYCLE;
  ADC_InitStruct.ADC_ContinueChannelSel = ADC_CONTINUE_CHANNEL_0 | ADC_CONTINUE_CHANNEL_1 | ADC_CONTINUE_CHANNEL_2 |
                                          ADC_CONTINUE_CHANNEL_3 | ADC_CONTINUE_CHANNEL_4;
  ADC_InitStruct.ADC_SingleContinueMode = ADC_MODE_CONTINUE;
  ADC_InitStruct.ADC_ClkSel = ADC_CLOCK_PCLK_DIV64;
  ADC_InitStruct.ADC_ConversionTimes = CONVERSION_NUM;
  ADC_InitStruct.ADC_CircleMode = ADC_MULTICHANNEL_NONCIRCLE;
  ADC_InitStruct.ADC_AutoAccumulation = ADC_AUTOACC_DISABLE;
  ADC_InitStruct.ADC_ExternalTrigConv1 = ADC_SOFTWARE_START;
  ADC_InitStruct.ADC_ExternalTrigConv2 = ADC_SOFTWARE_START;
  ADC_Init(&ADC_InitStruct);

  ADC_Cmd(ENABLE);
  ADC_ITConfig(ADC_IT_CHANNEL4 | ADC_IT_CONTINUE, ENABLE);
  NVIC_SetPriority(ADC_IRQn, 1);
  NVIC_EnableIRQ(ADC_IRQn);

  ADC_SoftwareStartConvCmd(ENABLE);
}

/**
  * @brief This function handles ADC Interrupt.
  */
void ADC_IRQHandler(void)
{
  if ((ADC_GetFlagStatus(ADC_INTFLAG_CHANNEL4)) != RESET)
  {
    Channel_0_Value[buffer_index] = ADC_GetConversionValue(ADC_CONTINUE_CHANNEL_0);
    Channel_1_Value[buffer_index] = ADC_GetConversionValue(ADC_CONTINUE_CHANNEL_1);
    Channel_2_Value[buffer_index] = ADC_GetConversionValue(ADC_CONTINUE_CHANNEL_2);
    Channel_3_Value[buffer_index] = ADC_GetConversionValue(ADC_CONTINUE_CHANNEL_3);
    Channel_4_Value[buffer_index] = ADC_GetConversionValue(ADC_CONTINUE_CHANNEL_4);
    buffer_index++;
    ADC_ClearFlag(ADC_INTFLAG_CHANNEL4); 
  }
  if ((ADC_GetFlagStatus(ADC_IT_CONTINUE)) != RESET)
  { 
    complete_flag = 1;
    ADC_ClearFlag(ADC_IT_CONTINUE);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
