/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t complete_flag = 0;
uint32_t Adc_Value = 0;
/* Private function prototypes -----------------------------------------------*/
void MY_ADC_Init(void);
void EXTI_Init(void);
/* Private functions ---------------------------------------------------------*/

/* Give PA2 a rising edge to use the test program */
int main(void)
{
  SystemCoreClockUpdate();
  uart1_init(24000000, 115200);

  EXTI_Init();
  MY_ADC_Init();

  /* Infinite loop */
  while (1)
  {
    if (complete_flag == 1)
    {
      complete_flag = 0;
      printf("ADC conversion value is %d\r\n", Adc_Value);
    }
  }
}

void EXTI_Init(void)
{
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

  GPIO_Init(GPIOA, GPIO_Pin_2, GPIO_PUPD_DOWN | GPIO_MODE_IN | GPIO_SPEED_HIGH);
  GPIO_EXTIConfig(GPIOA, GPIO_Pin_2, GPIO_EXTI_IT_ENABLE | GPIO_EXTI_TRIGGER_EDGE | GPIO_EXTI_TRIGGER_RISSING);
  GPIO_EXTI_ClearFlag(GPIOA, GPIO_Pin_2);
}

/**
  * @brief  ADC Configuration(Channel0, single mode, no auto acceleration, 
  *         64 clock division, software start, sample time: 8 cycles)
  * @note   Channel_0 conversion date is sample value from PC6
  * @retval None
  */
void MY_ADC_Init(void)
{
  ADC_InitTypeDef ADC_InitStruct = {0};

  RCC_APBPeriphClockCmd(RCC_APBPeriph_ADC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);

  GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);

  ADC_InitStruct.ADC_SamplingTime = ADC_SAMPLE_8CYCLE;
  ADC_InitStruct.ADC_SingleChannelSel = ADC_SINGLE_CHANNEL_0;
  ADC_InitStruct.ADC_SingleContinueMode = ADC_MODE_SINGLE;
  ADC_InitStruct.ADC_ClkSel = ADC_CLOCK_PCLK_DIV64;
  ADC_InitStruct.ADC_CircleMode = ADC_MULTICHANNEL_NONCIRCLE;
  ADC_InitStruct.ADC_AutoAccumulation = ADC_AUTOACC_DISABLE;
  ADC_InitStruct.ADC_ExternalTrigConv1 = ADC_EXTTRIG1_PA2_INT;
  ADC_InitStruct.ADC_ExternalTrigConv2 = ADC_EXTTRIG2_PA2_INT;
  ADC_Init(&ADC_InitStruct);

  ADC_ITConfig(ADC_IT_CHANNEL0, ENABLE);
  NVIC_SetPriority(ADC_IRQn, 2);
  NVIC_EnableIRQ(ADC_IRQn);
  ADC_Cmd(ENABLE);
}

/**
  * @brief This function handles ADC Interrupt.
  */
void ADC_IRQHandler(void)
{
  if (ADC_GetFlagStatus(ADC_INTFLAG_CHANNEL0) != RESET)
  {
    complete_flag = 1;
    Adc_Value = ADC_GetConversionValue(ADC_SINGLE_CHANNEL_0);
    GPIO_EXTI_ClearFlag(GPIOA, GPIO_Pin_2);
    ADC_ClearFlag(ADC_INTFLAG_CHANNEL0);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
