/**
 * @file    mg32l003_crc.h
 * @author  megawin Application Team
 * @version V0.0.5
 * @date    13-August-2024
 * @brief   This file contains all the functions prototypes for the CRC firmware
 *          library.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MG32L003_CRC_H
#define __MG32L003_CRC_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"

/** @addtogroup MG32L003_StdPeriph_Driver
  * @{
  */

/** @addtogroup CRC
  * @{
  */

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/

/** @defgroup TEMPLATE_Exported_Constants
  * @{
  */

#define CRC_DataAddress (CRC_BASE + 0x80) /*!< 0x80 ~ 0xFF is allowable */

/**
  * @}
  */

/* Exported macro ------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

void CRC_InitResult(void);
void CRC_DeInit(void);
uint32_t CRC_Accumulate(const uint8_t *ptr_data, uint32_t bufferLength);
uint32_t CRC_Calculate(const uint8_t *ptr_data, uint32_t bufferLength);

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /* __MG32L003_CRC_H */
