;/**************************************************************************//**
; * @file     startup_mg32l003.s
; * @brief    CMSIS Core Device Startup File for
; *           MG32L003 Device Series
; * @version  V0.0.5
; * @date     13-August-2024
; *
; * @note
; *
; ******************************************************************************/
;/* Copyright (c) 2011 - 2012 ARM LIMITED
;
;   All rights reserved.
;   Redistribution and use in source and binary forms, with or without
;   modification, are permitted provided that the following conditions are met:
;   - Redistributions of source code must retain the above copyright
;     notice, this list of conditions and the following disclaimer.
;   - Redistributions in binary form must reproduce the above copyright
;     notice, this list of conditions and the following disclaimer in the
;     documentation and/or other materials provided with the distribution.
;   - Neither the name of ARM nor the names of its contributors may be used
;     to endorse or promote products derived from this software without
;     specific prior written permission.
;   *
;   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
;   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
;   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
;   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
;   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
;   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
;   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
;   POSSIBILITY OF SUCH DAMAGE.
;   ---------------------------------------------------------------------------*/
;/*
;//-------- <<< Use Configuration Wizard in Context Menu >>> ------------------
;*/


; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000200

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts
                DCD     GPIOA_IRQHandler          ;  0: GPIOA
                DCD     GPIOB_IRQHandler          ;  1: GPIOB
                DCD     GPIOC_IRQHandler          ;  2: GPIOC
                DCD     GPIOD_IRQHandler          ;  3: GPIOD
                DCD     FLASH_IRQHandler          ;  4: FLASH
                DCD     0                         ;  5: Reserved
                DCD     UART1_IRQHandler          ;  6: UART1
                DCD     UART2_IRQHandler          ;  7: UART2
                DCD     LPUART_IRQHandler         ;  8: LPUART
                DCD     0                         ;  9: Reserved
                DCD     SPI_IRQHandler            ; 10: SPI
                DCD     0                         ; 11: Reserved
                DCD     I2C_IRQHandler            ; 12: I2C
                DCD     0                         ; 13: Reserved
                DCD     TIM10_IRQHandler          ; 14: TIM10
                DCD     TIM11_IRQHandler          ; 15: TIM11
                DCD     LPTIM_IRQHandler          ; 16: LPTIM
                DCD     0                         ; 17: Reserved
                DCD     TIM1_IRQHandler           ; 18: TIM1
                DCD     TIM2_IRQHandler           ; 19: TIM2
                DCD     0                         ; 20: Reserved
                DCD     PCA_IRQHandler            ; 21: PCA
                DCD     WWDG_IRQHandler           ; 22: WWDG
                DCD     IWDG_IRQHandler           ; 23: IWDG
                DCD     ADC_IRQHandler            ; 24: ADC
                DCD     LVD_IRQHandler            ; 25: LVD
                DCD     VCMP_IRQHandler           ; 26: VCMP
                DCD     0                         ; 27: Reserved
                DCD     AWK_IRQHandler            ; 28: AWK
                DCD     OWIRE_IRQHandler          ; 29: OWIRE
                DCD     RTC_IRQHandler            ; 30: RTC
                DCD     CLKTRIM_IRQHandler        ; 31: CLKTRIM
__Vectors_End

__Vectors_Size  EQU     __Vectors_End - __Vectors

                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  SystemInit
                IMPORT  __main
                LDR     R0, =SystemInit
                BLX     R0
                LDR     R0, =__main
                BX      R0
                ENDP


; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler               [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT  GPIOA_IRQHandler          [WEAK]
                EXPORT  GPIOB_IRQHandler          [WEAK]
                EXPORT  GPIOC_IRQHandler          [WEAK]
                EXPORT  GPIOD_IRQHandler          [WEAK]
                EXPORT  FLASH_IRQHandler          [WEAK]
                EXPORT  UART1_IRQHandler          [WEAK]
                EXPORT  UART2_IRQHandler          [WEAK]
                EXPORT  LPUART_IRQHandler         [WEAK]
                EXPORT  SPI_IRQHandler            [WEAK]
                EXPORT  I2C_IRQHandler            [WEAK]
                EXPORT  TIM10_IRQHandler          [WEAK]
                EXPORT  TIM11_IRQHandler          [WEAK]
                EXPORT  LPTIM_IRQHandler          [WEAK]
                EXPORT  TIM1_IRQHandler           [WEAK]
                EXPORT  TIM2_IRQHandler           [WEAK]
                EXPORT  PCA_IRQHandler            [WEAK]
                EXPORT  WWDG_IRQHandler           [WEAK]
                EXPORT  IWDG_IRQHandler           [WEAK]
                EXPORT  ADC_IRQHandler            [WEAK]
                EXPORT  LVD_IRQHandler            [WEAK]
                EXPORT  VCMP_IRQHandler           [WEAK]
                EXPORT  AWK_IRQHandler            [WEAK]
                EXPORT  OWIRE_IRQHandler          [WEAK]
                EXPORT  RTC_IRQHandler            [WEAK]
                EXPORT  CLKTRIM_IRQHandler        [WEAK]

GPIOA_IRQHandler
GPIOB_IRQHandler
GPIOC_IRQHandler
GPIOD_IRQHandler
FLASH_IRQHandler
UART1_IRQHandler
UART2_IRQHandler
LPUART_IRQHandler
SPI_IRQHandler
I2C_IRQHandler
TIM10_IRQHandler
TIM11_IRQHandler
LPTIM_IRQHandler
TIM1_IRQHandler
TIM2_IRQHandler
PCA_IRQHandler
WWDG_IRQHandler
IWDG_IRQHandler
ADC_IRQHandler
LVD_IRQHandler
VCMP_IRQHandler
AWK_IRQHandler
OWIRE_IRQHandler
RTC_IRQHandler
CLKTRIM_IRQHandler

                B       .

                ENDP


                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap

__user_initial_stackheap PROC
                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR
                ENDP

                ALIGN

                ENDIF


                END
