/******************************************************************************/
/* RETARGET.C: 'Retarget' layer for target-dependent low level functions      */
/******************************************************************************/
/* This file is part of the uVision/ARM development tools.                    */
/* Copyright (c) 2005 Keil Software. All rights reserved.                     */
/* This software may only be used under the terms of a valid, current,        */
/* end user licence from KEIL for a compatible version of KEIL software       */
/* development tools. Nothing else gives you the right to use this software.  */
/******************************************************************************/

#include <stdio.h>
#include "mg32l003.h"


#pragma import(__use_no_semihosting_swi)

struct __FILE { int handle; /* Add whatever you need here */ };
FILE __stdout;
FILE __stdin;


int fputc(int ch, FILE *f) {
  UART1->SBUF = (ch & 0xFF);
  while (!(UART1->INTSR & UART_INTSR_TI));
  UART1->INTCLR |= UART_INTCLR_TICLR_Msk;

  return ch;
}

int fgetc(FILE *f) {
  uint8_t ch;

  while (!(UART1->INTSR & UART_INTSR_RI));
  ch = (UART1->SBUF & 0xFF);
  UART1->INTCLR |= UART_INTCLR_RICLR_Msk;

  return ch;
}

int ferror(FILE *f) {
  /* Your implementation of ferror */
  return EOF;
}

void _ttywrch(int ch) {
}

int __backspace()
{
  return 0;
}

void _sys_exit(int return_code) {
  while (1);    /* endless loop */
}
