/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define LPTIM_TIMES           10000
#define LPTIMx_FREQ           10000  /* 10KHz */
#define LPTIMx_RELOADVALUE    (0xFFFF - 24000000 / LPTIMx_FREQ)

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint32_t LpTimUpdateCnt = 0;

/* Private function prototypes -----------------------------------------------*/
void MY_VCMP_Init(void);
void LPTIM_Init(void);

/* Private functions ---------------------------------------------------------*/

/* Note: If the input voltage in PC5 is lower than 1.25 v(for 32 pin the voltage will be 0.785v), 
         then uart1 will print message about every 1 second.
         Or there will be nothing in uart1.
*/
int main(void)
{
  SystemCoreClockUpdate();

  uart1_init(24000000, 115200);
  MY_VCMP_Init();
  LPTIM_Init();

  /* Infinite loop */
  while (1)
  {
    /* Every 0.0001s LPTIM will count overflow and generate a interrupt，
       1 second passed when there are 10000 interrupts */
    if (LpTimUpdateCnt == LPTIM_TIMES)
    {
      LpTimUpdateCnt = 0;
      printf("One second passed.\r\n");
    }
  }
}

void MY_VCMP_Init(void)
{
  VCMP_InitTypeDef VCMP_InitStruct;

  RCC_APBPeriphClockCmd(RCC_APBPeriph_LVDVC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);

  GPIO_Init(GPIOC, GPIO_Pin_5, GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH);
  GPIO_SetAFPin(GPIOC, GPIO_Pin_5, GPIO_AF15);

  VCMP_InitStruct.VcapDiv = VCMP_2P4_VCAPDIV;
  VCMP_InitStruct.Filter_Clk = VCMP_FILTER_CLK_PCLK;
  VCMP_InitStruct.NegPinSel = VCMP_INPUT_VCAPDIV;
  VCMP_InitStruct.PosPinSel = VCMP_INPUT_1;
  VCMP_InitStruct.Filter_Enable = VCMP_FILTER_ENABLE;
  VCMP_InitStruct.Fliter_Num = 0x800;
  VCMP_Init(&VCMP_InitStruct);

  /* Filter output is connected to LPTIM gate */
  VCMP_OutputConfig(VCMP_OUTCFG_LPTIM_GATE, ENABLE);
  VCMP_Cmd(ENABLE);
}

void LPTIM_Init(void)
{
  LPTIM_BaseInitTypeDef Base_InitStruct = {0};

  RCC_APBPeriphClockCmd(RCC_APBPeriph_LPTIM, ENABLE);

  Base_InitStruct.ClkSel = LPTIM_CLOCK_SOURCE_PCLK;
  Base_InitStruct.CntTimSel = LPTIM_TIMER_SELECT;
  Base_InitStruct.AutoReload = LPTIM_AUTORELOAD_ENABLE;
  Base_InitStruct.Period = LPTIMx_RELOADVALUE;
  Base_InitStruct.GateEnable = LPTIM_GATE_ENABLE;
  Base_InitStruct.GateLevel = LPTIM_GATELEVEL_LOW;
  LPTIM_BaseInit(&Base_InitStruct);

  LPTIM_ITCmd(ENABLE);
  NVIC_SetPriority(LPTIM_IRQn, 1);
  NVIC_EnableIRQ(LPTIM_IRQn);

  LPTIM_TCKCmd(ENABLE);
  LPTIM_Cmd(ENABLE);
}

void LPTIM_IRQHandler(void)
{
  if (LPTIM_GetITStatus() != RESET)
  {
    LPTIM_ClearITPendingBit();
    LpTimUpdateCnt++;
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
