/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "rtc.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
RTC_TimeTypeDef RTC_TimeStruct;
RTC_DateTypeDef RTC_DateStruct;
RTC_AlarmTypeDef RTC_AlarmStruct;

RTC_TimeTypeDef tTime;
RTC_DateTypeDef tDate;
RTC_AlarmTypeDef tAlarm;

extern uint8_t alarm1Flag;
extern uint8_t alarm2Flag;

void MAINCLK_FREQ_HSI_24M(void)
{
  RCC_HSIConfig(24000000, ENABLE);

  /* wait HSI clock ready */
  while ((RCC->HSICR & RCC_HSICR_HSIRDY) == RESET);

  RCC_SYSCLKConfig(RCC_SYSCLKSource_HSI);

  /* Wait till clock switch is ready */
  while ((RCC->SYSCLKSEL & RCC_SYSCLKSEL_CLKSW) != RCC_SYSCLKSource_HSI);
  
  SystemCoreClock = 24000000;
  
  RCC_AHBCLKConfig(RCC_AHBCLKDiv1);
  RCC_APBCLKConfig(RCC_APBCLKDiv1);
}

void SetSysClockToLSE(void)
{
  RCC_LSEConfig(RCC_LSE_ON);

  /* wait LSE clock ready */
  while ((RCC->LSECR & RCC_LSECR_LSERDY) == RESET);
  
  RCC_SYSCLKConfig(RCC_SYSCLKSource_LSE);

  /* Wait till clock switch is ready */
  while ((RCC->SYSCLKSEL & RCC_SYSCLKSEL_CLKSW) != RCC_SYSCLKSource_LSE);
  
  SystemCoreClock = LSE_VALUE;
  
  RCC_AHBCLKConfig(RCC_AHBCLKDiv1);
  RCC_APBCLKConfig(RCC_APBCLKDiv1);
}
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
void delay(volatile uint32_t n)
{
  while (n--)
    ;
}

int main(void)
{
  SystemCoreClockUpdate();
  My_RTC_Init();
  delay(10000000);
  
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA|RCC_AHBPeriph_GPIOB|RCC_AHBPeriph_GPIOC|RCC_AHBPeriph_GPIOD, ENABLE);
  GPIO_Init(GPIOC, GPIO_Pin_3 | GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL);  
  GPIO_SetBits(GPIOC, GPIO_Pin_3 | GPIO_Pin_4);  
  
  
  /* Infinite loop */
  while (1)
  {
    RCC_APBPeriphResetCmd(RCC_APBPeriph_UART1, ENABLE);
    RCC_APBPeriphResetCmd(RCC_APBPeriph_UART1, DISABLE);
    RCC_AHBPeriphResetCmd(RCC_AHBPeriph_GPIOD, ENABLE);
    RCC_AHBPeriphResetCmd(RCC_AHBPeriph_GPIOD, DISABLE);
    RCC_AHBPeriphResetCmd(RCC_AHBPeriph_GPIOA, ENABLE);
    RCC_AHBPeriphResetCmd(RCC_AHBPeriph_GPIOA, DISABLE);
    
    SetSysClockToLSE();
    RCC_HSIConfig(24000000, DISABLE);

    PWR_EnterDEEPSLEEPMode();
    MAINCLK_FREQ_HSI_24M();
    SystemCoreClockUpdate();
    uart1_init(24000000, 115200);
    
    do
    {
      RTC_GetTime(RTC_Format_BIN, &RTC_TimeStruct);
      RTC_GetDate(RTC_Format_BIN, &RTC_DateStruct);
    } while (RTC_TimeStruct.RTC_Seconds == tTime.RTC_Seconds);

    tTime = RTC_TimeStruct;
    tDate = RTC_DateStruct;
    delay(100);

    if (alarm2Flag)
    {
      printf("alarm cen=%d %02d/%02d/%02d weekday=%d, AMPM=%d %02d:%02d:%02d \r\n", tDate.RTC_Cen,
                                                                                    tDate.RTC_Year,
                                                                                    tDate.RTC_Month,
                                                                                    tDate.RTC_Date,
                                                                                    tDate.RTC_WeekDay,
                                                                                    tTime.RTC_H12, 
                                                                                    tTime.RTC_Hours,
                                                                                    tTime.RTC_Minutes,
                                                                                    tTime.RTC_Seconds);
      alarm2Flag = 0;
    }
    else
    {
      printf("time  cen=%d %02d/%02d/%02d weekday=%d, AMPM=%d %02d:%02d:%02d \r\n", tDate.RTC_Cen,
                                                                                    tDate.RTC_Year,
                                                                                    tDate.RTC_Month,
                                                                                    tDate.RTC_Date,
                                                                                    tDate.RTC_WeekDay,
                                                                                    tTime.RTC_H12, 
                                                                                    tTime.RTC_Hours,
                                                                                    tTime.RTC_Minutes,
                                                                                    tTime.RTC_Seconds);
    }
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
