/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t test_flag = 0;
/* Private function prototypes -----------------------------------------------*/
void MY_LVD_Init(void);
/* Private functions ---------------------------------------------------------*/

/* You should pull vcc down below 2.7v(for 32 pin the voltage is 3.4v) to use this test program. */
int main(void)
{
  SystemCoreClockUpdate();

  uart1_init(24000000, 115200);
  MY_LVD_Init();

  /* Infinite loop */
  while (1)
  {
    if (test_flag == 1)
    {
      printf("LVD interrupt generated!\r\n");
      test_flag = 0;
    }
  }
}

void MY_LVD_Init(void)
{
  LVD_InitTypeDef LVD_InitStruct = {0};

  /* Start LSI for LVD filter */
  RCC_LSIConfig(LSI_VALUE_32K, RCC_LSI_STARTUP_4CYCLE, ENABLE);
  RCC_APBPeriphClockCmd(RCC_APBPeriph_LVDVC, ENABLE);

  LVD_InitStruct.FltClkSel = LVD_FLTCLK_LSI;
  LVD_InitStruct.VoltageLevel = LVD_VOLLEVEL_6;
  LVD_InitStruct.TriggerSel = LVD_TRIGGER_RISING;
  LVD_InitStruct.Action = LVD_ACTION_INTERRUPT;
  LVD_InitStruct.FltNum = 0x10;
  LVD_Init(&LVD_InitStruct);

  LVD_ITCmd(ENABLE);
  NVIC_SetPriority(LVD_IRQn, 1);
  NVIC_EnableIRQ(LVD_IRQn);
  LVD_Cmd(ENABLE);
}

void LVD_IRQHandler(void)
{
  if (LVD_GetFlagStatus() != RESET)
  {
    LVD_ClearITPendingBit();
    test_flag = 1;
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
