/* Includes ------------------------------------------------------------------*/
#include "mg32l003.h"
#include "drv_eeprom_24c02.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t i2c_writeData[256];
uint8_t i2c_readData[256];
uint8_t i2c_status = 0;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(volatile uint32_t n)
{
  while (n--)
    ;
}

/* You shoule change the pWData every time to check the I2C */
int main(void)
{
  SystemCoreClockUpdate();
  
  uart1_init(24000000, 115200);
  
  eeprom_24c02_init();

  for(uint16_t i = 0; i < 256; i++)
  {
    i2c_writeData[i] = i;
  }

  for (uint16_t i = 0; i < 256; i += 8)
  {
    eeprom_24c02_page_write(i, i2c_writeData + i, 8);
    while (eeprom_24c02_probe());
  }

  eeprom_24c02_sequential_read(0x0, i2c_readData, 256);

  for (uint16_t i = 0; i < 256; i ++)
  {
    if (i2c_readData[i] != i2c_writeData[i])
    {
      i2c_status = 1;
      break;
    }
    
    printf("add 0x%02X, data 0x%02X\r\n", i, i2c_readData[i]);
  }

  if (i2c_status)
  {
    printf("EEPROM 24c02 R/W Error \r\n");
  }
  else
  {
    printf("EEPROM 24c02 R/W Success \r\n");
  }
  
  /* Infinite loop */
  while (1)
  {

  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
