
#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#include "REG_MG84FG516.H"
#include "delay.H"

uCHAR	ADC_H;
uCHAR	ADC_L;

void ADC_Initial(void)
{
	ADCON0 = 0x80;						//enable ADC and select channel P1.0
	ADCFG0 = 0x10;						//ADC clk is sysclk / 8, ADRJ = 1
	
	P1AIO = 0x01;						//configure P1.0 as input only mode
	delay_ms(1);
}

void ADC_Start(void)
{
	ADCON0 |= 0x08;						//start AD conversion
	while(!(ADCON0 & 0x10));			//wait AD conversion finish
	ADCON0 &= 0xEF;						//Clear ADC interrupt flag
}

void main(void)
{
	ADC_Initial();
	
	while(1)
	{
		ADC_Start();
		
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
	}
}
