
#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#define    ISP_ENABLE          0x80              // Set ISP Enable
#define    ISP_DISABLE         0x00              // Set ISP Disable

#include "REG_MG84FG516.H"


void PageP_Write( uCHAR Addr , uCHAR Data )
  { ISPCR = ISP_ENABLE;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFD = Data;
    IFMT = 0x04;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
  }

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	ISPCR = ISP_ENABLE;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFMT = 0x05;
    SCMD = 0x46;
    SCMD = 0xB9;
	Data = IFD;
    ISPCR = ISP_DISABLE;
	
	return Data;
}

void BOD1_Initial(void)
{
	uCHAR tmp;

	tmp = PageP_Read(0x44);
	tmp &= 0xDF;
	tmp |= 0x10;								//2.4V interrupt
	PageP_Write(0x44, tmp);
	
	SFIE |= 0x04;								//enable BOF1 interrupt
	EIE1 |= 0x08;								//enable system flag interrupt	
}

void BOD1_INT(void)	interrupt	11	using	1
{
	PCON1 |= 0x04;								//write "1" to clear BOF1 interrupt flag
	P10 = ~P10;									//VDDC2.4V, |oͤ_
}


void main(void)
{
	BOD1_Initial();
	EA = 1;

	while(1);
}
